
import { useEffect } from 'react';
// Update progress for a playlist item
export const updateProgress = (channel, setChannel) => (itemId, newProgress) => {
  const item = channel.playlist.find(i => i.id === itemId);
  if (item) {
    setChannel(prevChannel => {
      const updatedPlaylist = prevChannel.playlist.map(item => {
        if (item.id === itemId) {
          return { ...item, progress: newProgress };
        }
        return item;
      });
      return { ...prevChannel, playlist: updatedPlaylist };
    });
  }
};

export function usePlayerState(tvRef, playerState, setPlayerState) {
  useEffect(() => {
    const interval = setInterval(() => {
      if (
        tvRef.current &&
        tvRef.current.defaultPlayer &&
        typeof tvRef.current.defaultPlayer.getPlayerState === 'function'
      ) {
        const state = tvRef.current.defaultPlayer.getPlayerState();
        if (state === 1) {
          if (playerState !== 'playing') setPlayerState('playing');
        } else {
          if (playerState !== 'paused') setPlayerState('paused');
        }
      }
    }, 300);
    return () => clearInterval(interval);
  }, [tvRef, playerState, setPlayerState]);
}
