<?php

namespace Drupal\tv\Brand;

/**
 * Collects all brand providers and returns the first available brand.
 */
class TvBrandCollector {

  /**
   * The brand providers.
   *
   * @var \Drupal\tv\Brand\TvBrandProviderInterface[]
   */
  protected array $providers = [];

  /**
   * TvBrandCollector constructor.
   *
   * @param iterable $providers
   *   An iterable of TvBrandProviderInterface services.
   */
  public function __construct(iterable $providers = []) {
    foreach ($providers as $provider) {
      $this->providers[] = $provider;
    }
  }

  /**
   * Returns the first available brand string from providers.
   *
   * @return string|null
   *   The brand string or NULL if no provider returns a brand.
   */
  public function getBrand(): ?string {
    foreach ($this->providers as $provider) {
      $brand = $provider->getBrand();
      if ($brand !== NULL && $brand !== '') {
        return $brand;
      }
    }
    return NULL;
  }

}
