<?php

namespace Drupal\tv\Channel;

use Drupal\node\NodeInterface;

/**
 * Collects all channel context providers and returns the first available channel node.
 */
class ChannelContextCollector {
  /**
   * @var \Drupal\tv\Channel\ChannelContextProviderInterface[]
   */
  protected $providers = [];

  /**
   * ChannelContextCollector constructor.
   *
   * @param iterable $providers
   *   An iterable of ChannelContextProviderInterface services.
   */
  public function __construct($providers = []) {
    if (!is_iterable($providers)) {
      $providers = [];
    }
    foreach ($providers as $provider) {
      $this->providers[] = $provider;
    }
  }

  /**
   * Returns the first available TV Channel node from providers.
   *
   * @param array $context
   *   Optional context for determining the channel.
   *
   * @return \Drupal\node\NodeInterface|null
   *   The TV Channel node or NULL.
   */
  public function getChannelNode(array $context = []): ?NodeInterface {
    foreach ($this->providers as $provider) {
      $node = $provider->getChannelNode($context);
      if ($node instanceof NodeInterface) {
        return $node;
      }
    }
    return NULL;
  }

  /**
   * Returns the TV Channel nodes from providers.
   *
   * @param array $context
   *   Optional context for determining the channel.
   *
   * @return \Drupal\node\NodeInterface[]
   *   The TV Channel nodes, if any.
   */
  public function getChannelNodes(array $context = []): array {
    $nodes = [];
    foreach ($this->providers as $provider) {
      $provider_nodes = $provider->getChannelNodes($context);
      if (is_array($provider_nodes)) {
        $nodes = array_merge($nodes, $provider_nodes);
      }
    }
    return $nodes;
  }
}
