import YouTube from "./Embed/YouTube/YouTube";


function Player(params) {

    const { tvRef, fullscreen, idle } = params;

    // Sizing logic
    const playerStyle = {
        position: 'relative',
        width: '100%',
        height: '100%',
        zIndex: fullscreen ? 1000 : undefined,
        background: '#000',
        display: 'flex',
        alignItems: 'center',
        justifyContent: 'center',
        overflow: 'hidden',
        opacity: idle ? 0.7 : 1,
    };

    // Only allow playable items (≥30s left)
    function isPlayable(item) {
        if (!item || !item.duration) return false;
        const duration = typeof item.duration === 'number' ? item.duration : parseInt(item.duration, 10);
        const progress = item.progress || 0;
        const remaining = duration - ((progress / 100) * duration);
        return duration > 0 && remaining >= 30;
    }

    let item = params.item || 0;
    const playlist = params.channel && params.channel.playlist ? params.channel.playlist : [];
    const playableIndexes = playlist.map((it, idx) => isPlayable(it) ? idx : null).filter(idx => idx !== null);
    const video = playlist[item];

    // If no playable items, show message and do not render YouTube at all
    if (playableIndexes.length === 0) {
        return <div>No playable videos in playlist</div>;
    }

    // Only render YouTube if the item is playable
    if (!isPlayable(playlist[item])) {
        return <div>Loading...</div>;
    }

    // Determine video type (YouTube, Vimeo, Rumble) from playlist[item]
    let EmbedComponent = null;
    // Detect type by url if explicit type is missing
    if (video) {
        const url = video.url || '';
        if (video.type === 'youtube' || url.includes('youtube.com') || url.includes('youtu.be')) {
            EmbedComponent = YouTube;
        }
    }
    if (!EmbedComponent) {
        return <div>No supported video type found</div>;
    }

    return (
        <div
            className={`Player${fullscreen ? ' Player--fullscreen' : ''}`}
            style={playerStyle}
            ref={tvRef}
            tabIndex={-1}
        >
            <div style={{position: 'relative', width: '100%', height: '100%'}}>
                {(() => {
                    let EmbedComponent = null;
                    if (video) {
                        const url = video.url || '';
                        if (video.type === 'youtube' || url.includes('youtube.com') || url.includes('youtu.be')) {
                            EmbedComponent = YouTube;
                        }
                    }
                    return EmbedComponent ? (
                        <EmbedComponent
                          channel={params.channel}
                          item={item}
                          onVideoEnd={params.onVideoEnd}
                          updateProgress={params.updateProgress}
                          tvRef={tvRef}
                        ></EmbedComponent>
                    ) : (
                        <div>No supported video type found</div>
                    );
                })()}
            </div>
        </div>
    );
}

export default Player;
