<?php

namespace Drupal\tv\Brand;

/**
 * Interface for TV brand providers.
 *
 * Implement this interface and tag your service with 'tv.brand_provider'
 * to provide a default brand string for the TV player overlay.
 *
 * Example service definition in another module's services.yml:
 * @code
 * services:
 *   mymodule.tv_brand_provider:
 *     class: Drupal\mymodule\Brand\MyBrandProvider
 *     tags:
 *       - { name: tv.brand_provider, priority: 0 }
 * @endcode
 */
interface TvBrandProviderInterface {

  /**
   * Returns the brand string for the TV player overlay.
   *
   * @return string|null
   *   The brand string, or NULL if not available.
   */
  public function getBrand(): ?string;

}
