<?php

namespace Drupal\tv\Controller;

use Drupal\Core\Controller\ControllerBase;
use Drupal\Core\DependencyInjection\ContainerInjectionInterface;
use Drupal\tv\Service\TvChannelsServiceInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\HttpFoundation\JsonResponse;

/**
 * Returns responses for Node routes.
 */
class TvController extends ControllerBase implements ContainerInjectionInterface {

    protected TvChannelsServiceInterface $channelsService;

    public function __construct(TvChannelsServiceInterface $channelsService) {
        $this->channelsService = $channelsService;
    }

    public static function create(ContainerInterface $container): static {
        return new static(
            $container->get('tv.channels')
        );
    }

    public function getChannels(): JsonResponse
    {
        $channels = [];
        foreach ($this->channelsService->getChannels() as $channel) {
            $channels[] = [
                'id' => $channel->id(),
                'title' => $channel->getTitle(),
                // @todo 'posterUrl' => $channel->getPosterUrl(),
                'playlist' => '/node/' . $channel->id() . '/channel',
            ];
        }

        return new JsonResponse([
            'title' => 'TV Channels',
            'method' => 'GET',
            'status'=> JsonResponse::HTTP_OK,
            'channels' => $channels,
        ], JsonResponse::HTTP_OK);
    }

}
