<?php

namespace Drupal\tv\Entity\Collection;

use Drupal\Core\Entity\EntityTypeManagerInterface;
use Drupal\node\Entity\Node;
use Drupal\tv\Entity\TvChannel;
use Drupal\tv\Service\TvChannelServiceInterface;

class TvChannelCollection extends EntityCollection {

    private EntityTypeManagerInterface $entityTypeManager;

    private TvChannelServiceInterface $tvChannelService;

    public function __construct(EntityTypeManagerInterface $entityTypeManager, TvChannelServiceInterface $tvChannelService)
    {
        $this->entityTypeManager = $entityTypeManager;
        $this->tvChannelService = $tvChannelService;
    }

    public function load(): static
    {
        $result = $this->entityTypeManager->getStorage('node')
            ->getQuery()
            ->condition('type', 'tv_channel')
            ->condition('status', 1)
            ->sort('title')
            ->accessCheck()
            ->execute();
        foreach ($result as $nid) {
            $items = $this->tvChannelService->getItemIds(Node::load($nid));
            if (count($items)) {
              $this->append($nid);
            }
        }
        return $this;
    }

    public function current(): TvChannel
    {
        return (new TvChannel($this->entityTypeManager))
            ->load($this->getIterator()->current());
    }
}
