<?php

namespace Drupal\tv\Service;

use Drupal\Core\Entity\EntityTypeManagerInterface;
use Drupal\tv\Entity\Collection\TvChannelCollection;

class TvChannelsService implements TvChannelsServiceInterface {
    private EntityTypeManagerInterface $entityTypeManager;
    private TvChannelServiceInterface $channelService;

    public function __construct(EntityTypeManagerInterface $entityTypeManager, TvChannelServiceInterface $channelService)
    {
        $this->entityTypeManager = $entityTypeManager;
        $this->channelService = $channelService;
    }

    public function getChannels(): TvChannelCollection {
        return (new TvChannelCollection($this->entityTypeManager, $this->channelService))->load();
    }
}
