// Format seconds as HH:MM:SS
function formatDuration(seconds) {
    seconds = Math.max(0, Math.floor(seconds));
    const h = Math.floor(seconds / 3600);
    const m = Math.floor((seconds % 3600) / 60);
    const s = seconds % 60;
    if (h > 0) {
        return `${h}:${m.toString().padStart(2, '0')}:${s.toString().padStart(2, '0')}`;
    } else {
        return `${m}:${s.toString().padStart(2, '0')}`;
    }
}

function getInSeconds(timestamp) {
    let a = timestamp.split(':');
    return (+a[0]) * 60 * 60 + (+a[1]) * 60 + (+a[2]);
}

function parseDuration(duration) {
    if (!duration || typeof duration !== 'string') return 0;
    const match = duration.match(/PT(?:(\d+)H)?(?:(\d+)M)?(?:(\d+)S)?/);
    if (!match) return 0;
    const hours = parseInt(match[1] || 0);
    const minutes = parseInt(match[2] || 0);
    const seconds = parseInt(match[3] || 0);
    return hours * 3600 + minutes * 60 + seconds;
}

// Generate a unique cookie name based on the current page path
function getTvCookieName(prefix = 'tv_channel') {
    if (typeof window === 'undefined') return prefix;
    const path = window.location.pathname
        .replace(/[^a-zA-Z0-9]/g, '_')  // Replace non-alphanumeric chars with underscore
        .replace(/_+/g, '_')             // Collapse multiple underscores
        .replace(/^_|_$/g, '');          // Trim leading/trailing underscores
    return `${prefix}_${path || 'home'}`;
}

// Get a cookie value by name
function getCookie(name) {
    if (typeof document === 'undefined') return null;
    const match = document.cookie.match(new RegExp('(^| )' + name + '=([^;]+)'));
    return match ? decodeURIComponent(match[2]) : null;
}

// Set a cookie with optional expiry (default 30 days)
function setCookie(name, value, days = 30) {
    if (typeof document === 'undefined') return;
    const expires = new Date(Date.now() + days * 864e5).toUTCString();
    document.cookie = `${name}=${encodeURIComponent(value)}; expires=${expires}; path=/; SameSite=Lax`;
}

export { formatDuration, getInSeconds, parseDuration, getTvCookieName, getCookie, setCookie };
