<?php

namespace Drupal\tv\Service;

use Drupal\Core\Entity\EntityTypeManagerInterface;
use Drupal\tv\Entity\Collection\TvChannelCollection;

class TvChannelsService implements TvChannelsServiceInterface {
    private EntityTypeManagerInterface $entityTypeManager;
    private TvChannelServiceInterface $channelService;

    public function __construct(EntityTypeManagerInterface $entityTypeManager, TvChannelServiceInterface $channelService)
    {
        $this->entityTypeManager = $entityTypeManager;
        $this->channelService = $channelService;
    }

    public function getChannels(): TvChannelCollection {
        /** @var \Drupal\tv\Channel\ChannelContextCollector $contextCollector */
        $contextCollector = \Drupal::service('tv.channel_context_collector');
        if ($contextCollector->getProviderCount() === 0) {
            // No context providers registered, return all channels.
            return (new TvChannelCollection($this->entityTypeManager, $this->channelService))->load();
        }
        return $contextCollector->getChannels();
    }
}
