<?php

namespace Drupal\tv\Service;

use Drupal\Core\Entity\EntityTypeManagerInterface;
use Drupal\Core\Routing\CurrentRouteMatch;
use Drupal\node\NodeInterface;
use Drupal\tv\Entity\Collection\TvChannelCollection;
use Symfony\Component\HttpFoundation\Request;
use Drupal\path_alias\AliasManager;

class TvChannelsService implements TvChannelsServiceInterface {
    private EntityTypeManagerInterface $entityTypeManager;
    private TvChannelServiceInterface $channelService;
    private CurrentRouteMatch $currentRouteMatch;
    private Request $request;
    private AliasManager $pathAliasManager;

    public function __construct(EntityTypeManagerInterface $entityTypeManager, TvChannelServiceInterface $channelService)
    {
        $this->entityTypeManager = $entityTypeManager;
        $this->channelService = $channelService;

        // @todo inject this
        $this->currentRouteMatch = \Drupal::service('current_route_match');
        $this->request = \Drupal::request();
        $this->pathAliasManager = \Drupal::service('path_alias.manager');
    }

    public function getChannels(): TvChannelCollection {
        // Return the relevant TV Channel if the referrer is a TV Channel node.
        $referrer = $this->request->headers->get('referer');
        if ($referrer) {
          $parsed_url = parse_url($referrer);
          $referrer_path = $parsed_url['path'] ?? '';
          $base_path = $this->request->getBasePath();
          if ($base_path && strpos($referrer_path, $base_path) === 0) {
            $referrer_path = substr($referrer_path, strlen($base_path));
          }
          if ($referrer_path) {
            $system_path = $this->pathAliasManager->getPathByAlias($referrer_path);
            if (preg_match('#^/node/(\d+)$#', $system_path, $matches)) {
              $referrer_node = $this->entityTypeManager->getStorage('node')->load($matches[1]);
              if ($referrer_node instanceof NodeInterface && $referrer_node->bundle() === 'tv_channel') {
                $channels = new TvChannelCollection($this->entityTypeManager, $this->channelService);
                $channels->append($referrer_node->id());
                return $channels;
              }
            }
          }
        }

        // Try to get channels from context providers, or load all channels if none.
        /** @var \Drupal\tv\Channel\ChannelContextCollector $contextCollector */
        $contextCollector = \Drupal::service('tv.channel_context_collector');
        if ($contextCollector->getProviderCount()) {
            return $contextCollector->getChannels()->sort();
        }
        else {
            $channels = new TvChannelCollection($this->entityTypeManager, $this->channelService);
            return $channels->load()->sort();
        }
    }
}
