<?php

namespace Drupal\tv\ChannelItemSorter;

use Drupal\tv\Entity\TvChannel;

/**
 * Interface for TV channel item sorters.
 *
 * Implement this interface to provide custom sorting logic for channel items.
 */
interface TvChannelItemSorterInterface {

  /**
   * Sorts channel items.
   *
   * @param array $items
   *   The items to sort. Each item is an associative array with keys like
   *   'id', 'name', 'weight', 'createdDt', etc.
   * @param \Drupal\tv\Entity\TvChannel $channel
   *   The TV channel.
   *
   * @return array
   *   The sorted items.
   */
  public function sort(array $items, TvChannel $channel): array;

}
