<?php

namespace Drupal\tv\ChannelItemProvider;

use Drupal\Core\Entity\EntityTypeManagerInterface;
use Drupal\Core\Extension\ModuleHandlerInterface;
use Drupal\tv\Entity\TvChannel;
use Symfony\Component\DependencyInjection\Attribute\AutoconfigureTag;

/**
 * Provides remote_video media items for TV channels.
 */
#[AutoconfigureTag('tv.channel_item_provider')]
class DefaultVideoProvider implements TvChannelItemProviderInterface {

  public function __construct(
    protected EntityTypeManagerInterface $entityTypeManager,
    protected ModuleHandlerInterface $moduleHandler,
  ) {}

  /**
   * {@inheritdoc}
   */
  public function getWeight(): int {
    return 0;
  }

  /**
   * {@inheritdoc}
   */
  public function getMediaIds(TvChannel $channel): array {
    $tags = $channel->getTags();
    if (empty($tags)) {
      return [];
    }

    $query = $this->entityTypeManager->getStorage('media')->getQuery()
      ->condition('bundle', 'remote_video')
      ->condition('field_duration', 0, '>')
      ->condition('field_description', NULL, 'IS NOT NULL')
      ->condition('field_thumbnail', NULL, 'IS NOT NULL')
      ->condition('status', 1)
      ->accessCheck(TRUE);

    // Each video must have all the tags the channel has.
    foreach ($tags as $tag) {
      $query->condition($query->andConditionGroup()
        ->condition('field_tags', $tag->id()));
    }

    // Allow other modules to alter the query.
    $this->moduleHandler->alter('tv_channel_items_query', $query, $channel);

    return $query->execute();
  }

}
