<?php

namespace Drupal\tv\ChannelItemProvider;

use Drupal\tv\Entity\TvChannel;

/**
 * Interface for TV channel item providers.
 *
 * Implement this interface and tag your service with 'tv.channel_item_provider'
 * to provide additional media items to TV channels.
 */
interface TvChannelItemProviderInterface {

  /**
   * Returns the provider's weight for sorting.
   *
   * Providers with lower weights are processed first.
   *
   * @return int
   *   The weight (lower = higher priority).
   */
  public function getWeight(): int;

  /**
   * Provides media entity IDs for a channel.
   *
   * @param \Drupal\tv\Entity\TvChannel $channel
   *   The TV channel.
   *
   * @return int[]
   *   Array of media entity IDs.
   */
  public function getMediaIds(TvChannel $channel): array;

}
