<?php

namespace Drupal\tv\ChannelItemSorter;

use Drupal\tv\Entity\TvChannel;

/**
 * Default sorter: by weight ascending, then by creation date descending.
 */
class DefaultItemSorter implements TvChannelItemSorterInterface {

  /**
   * {@inheritdoc}
   */
  public function sort(array $items, TvChannel $channel): array {
    usort($items, function ($a, $b) {
      // Sort by weight first (ascending - lower weight = higher priority).
      $weightA = $a['weight'] ?? 0;
      $weightB = $b['weight'] ?? 0;
      if ($weightA !== $weightB) {
        return $weightA <=> $weightB;
      }
      // Then by creation date (descending - newest first).
      return ($b['createdDt'] ?? '') <=> ($a['createdDt'] ?? '');
    });

    return $items;
  }

}
