# TV Module
TV provides TV Apps, TV Channel entities & supporting infrastructure.

Each TV media entity is an application that works like a modern "Smart TV" & can run full-screen. Each TV media entity application can be controlled using standard-fare media center hotkeys.

## Installation
Install the module as you would any other Drupal module.

The module will create:
* a "TV Channel" content type
* a "TV" Block

The module will install [remote_video](https://www.drupal.org/project/remote_video) as a dependency. Visit `/admin/config/services/remote_video` to add your video service API key(s).

### Start the React app

#### DDEV
If running on a development machine, you'll need to install & start the React TV app.

1. `cd modules/tv/js/apps/tv`
2. `npm install`
3. `npm start`

#### Enable Development Mode

By default, the TV block loads the production build of the React app. To use the development build (typically running on `localhost:3000`), add this to your `settings.php` or `settings.local.php`:

```php
$settings['tv_use_dev_build'] = TRUE;
```

To switch back to production mode, remove the line or set it to `FALSE`.

This is environment-specific configuration, so each environment (local dev, staging, production) can have its own value without affecting others.

## Configuration
Create a TV Channel. Or several.

> A TV Channel is a dynamic collection of media that is often played in a linear fashion. A TV Channel can be tagged with taxonomy terms. A TV Channel will play relevant tagged media. TV Channel media may also be affected by the current user's context & brand-new relevant media.

### Create a "Drupal DriesNotes" Sample TV Channel

1. Visit `/admin/structure/taxonomy/manage/tags/add`
2. Create "Drupal", "Keynote" & "Dries" tags via that form.
3. Visit `/media/add/remote_video`.
4. Set `Video URL` to [Driesnote: Lille DrupalCon 2023](https://www.youtube.com/watch?v=tFxlDBLkLJc).
5. Set `Tags` to "Drupal", "Keynote" & "Dries".
6. Save the form.
7. Repeat steps 4-6 for [Driesnote: Pittsburgh DrupalCon 2023](https://www.youtube.com/watch?v=tNa4XKb3zds).
8. Repeat steps 4-6 for [Driesnote: Portland DrupalCon 2022](https://www.youtube.com/watch?v=Ig676RzJbLo).
9. Visit `/admin/structure/block` & place a "TV" block where you would prefer (e.g. the "Content" region on "TV Channel" pages).
10. Visit `/node/add/tv_channel` to create a "Drupal Keynotes" TV Channel.
11. Set the TV Channel title to "Drupal DriesNotes".
12. Set the TV Channel tags to "Drupal", "Keynote" & "Dries".
13. Submit the form to create the TV Channel.
14. Scroll down to view your new TV Channel.

Repeat the above to create more TV Channels.

## Programmatic Customization
TV Channel item queries can be modified by implementing `hook_tv_channel_items_query_alter`:

```php
function littletownpro_tv_channel_items_query_alter(Query $query, NodeInterface $channel) {
    $query->condition('name', 'Foo');
}
```

TV Channel item lists can be modified by implementing `hook_tv_channel_items_alter`:

```php
/**
 * Implements hook_tv_channel_items_alter().
 */
function mymodule_tv_channel_items_alter(array &$items, $context) {
    $preroll = [
        'name' => 'Thanks for watching!',
        'url' => '', // Video URL
        // ...
    ];
    array_unshift($items, $preroll);
}
```

### Brand Overlay
The TV player can display a brand overlay (lower third) when videos start playing. The brand can be configured at two levels:

#### Per-Channel Brand
Each TV Channel node has a `field_brand` field. Set this to display a channel-specific brand overlay (e.g., "My Channel TV").

#### Site-Wide Default Brand
To provide a default brand for all channels (used when `field_brand` is empty), implement a brand provider in your module:

1. Create a service tagged with `tv.brand_provider`:

```yaml
# mymodule.services.yml
services:
  mymodule.tv_brand_provider:
    class: Drupal\mymodule\Brand\MyBrandProvider
    tags:
      - { name: tv.brand_provider, priority: 0 }
```

2. Implement the `TvBrandProviderInterface`:

```php
<?php
// src/Brand/MyBrandProvider.php

namespace Drupal\mymodule\Brand;

use Drupal\tv\Brand\TvBrandProviderInterface;

class MyBrandProvider implements TvBrandProviderInterface {

  public function getBrand(): ?string {
    return 'My Site TV';
  }

}
```

The brand provider with the highest priority that returns a non-empty string will be used. This allows modules to dynamically determine the brand based on site configuration, current user, or other context.

## Usage
Each TV has two main modes of operation:
* "Channel" mode: the TV plays a Channel (e.g. category) of tagged media in a linear fashion, avoiding media that has been played for the user recently. The user can Play/Pause, change Channels, and view a Channel list with their computer remote.
* "Library" mode: the TV shows a media library of curated media as options for the user. Once the chosen media is done playing, the Library is shown again -- with the summary of their chosen media highlighted.

Content editors are able to embed a TV anywhere other media can be embedded. A TV can be configured to be context-aware. For instance, a relevant TV Channel can automatically be chosen based on the page the TV is embedded on. A TV can also be configured to ignore relevant options if they are deemed to be "expired" (e.g. older than N years). A TV can be configured to avoid playing promotional videos (and play premium videos) based on the current user's subscription status.

### Typical Use Cases
#### Busy Drupal Developer
Consider the case of a busy Drupal developer hoping to watch videos about the Automated Updates Strategic Initiative while starting laundry, making dinner, eating, washing dishes & folding clothes. The user could -- first -- navigate to the project page for that initiative & click Play (if that page has a TV embedded). The most recent relevant videos in the user's preferred language would play first. Re-runs would seldom occur & old videos wouldn't appear. The user is able to learn the latest about the initiative without having to routinely queue up a new video. When they navigate back to the page the following week, they can easily pick up where they left off.
