<?php
namespace Drupal\tv\Controller;

use Drupal\media\MediaInterface;
use Drupal\node\NodeInterface;
use Symfony\Component\HttpFoundation\JsonResponse;
use Drupal\tv\LowerThirdsList;

class LowerThirdsController {
  /**
   * Returns lower thirds overlay data as JSON for a channel and item.
   */
  public function getLowerThirds(NodeInterface $channel, MediaInterface $item) {
    // Try to get item-level lower thirds first.
    $list = \Drupal\tv\LowerThirdsList::getItemList($item);
    if (empty($list)) {
      // Fallback to channel-level lower thirds.
      $list = \Drupal\tv\LowerThirdsList::getChannelList($channel);
    }
    // Fallback to example data if still empty.
    if (empty($list)) {
      $list = [
        ['heading' => 'Example', 'text' => 'Sample lower third', 'qr' => ''],
      ];
    }
    return new JsonResponse($list);
  }
}
