# TV App Testing Quick Start

## Run Tests

```bash
cd web/modules/custom/tv/js/apps/tv

# Run all tests
npm test

# Run tests in watch mode (auto-rerun on file changes)
npm test -- --watch

# Run tests with coverage report
npm test -- --coverage

# Run specific test file
npm test helpers.test.js

# Run tests matching a pattern
npm test -- --testNamePattern="getInSeconds"
```

## Test Structure

```
src/
├── __tests__/
│   ├── README.md                    # Full testing documentation
│   ├── helpers.test.js              # ✅ Utility functions (100% coverage)
│   ├── tvStateMachine.test.js       # ✅ State management
│   ├── ErrorBoundary.test.js        # ✅ Error boundary component
│   ├── LowerThirdOverlay.test.js    # ✅ Simple presentational component
│   ├── Accordion.test.js            # ✅ Accordion container
│   ├── Player.test.js               # 📋 TODO - Core playback logic
│   ├── YouTube.test.js              # 📋 TODO - YouTube wrapper
│   └── Keys.test.js                 # 📋 TODO - Keyboard navigation
└── setupTests.js                     # Global test configuration
```

## Current Test Coverage

✅ **Implemented and Passing:**
- Utility functions (helpers.js)
- State machine basics
- Error boundary
- Simple components

📋 **Planned (Stub/TODO):**
- Player component (resume positions, progress tracking)
- YouTube wrapper (API integration, mute persistence)
- Keyboard navigation (Keys component)
- More complex integration tests

## Writing New Tests

### 1. Simple Pure Functions (Easiest)
```javascript
import { myFunction } from '../myModule';

describe('myFunction', () => {
  test('does what it should', () => {
    expect(myFunction(input)).toBe(expectedOutput);
  });
});
```

### 2. React Components
```javascript
import { render, screen, fireEvent } from '@testing-library/react';
import MyComponent from '../MyComponent';

describe('MyComponent', () => {
  test('renders correctly', () => {
    render(<MyComponent prop="value" />);
    expect(screen.getByText('Expected text')).toBeInTheDocument();
  });
});
```

### 3. Components with Mocks
```javascript
jest.mock('../tvStateMachine');

test('uses state machine', () => {
  const mockTransition = jest.fn();
  tvStateMachine.transition = mockTransition;

  render(<MyComponent />);
  fireEvent.click(screen.getByRole('button'));

  expect(mockTransition).toHaveBeenCalledWith('ACTION');
});
```

## Common Test Patterns

See `src/__tests__/README.md` for detailed patterns including:
- Mocking localStorage
- Mocking tvStateMachine
- Mocking YouTube API
- Testing async effects
- Testing user interactions

## Continuous Integration

Tests run automatically via `npm test` in CI pipeline.
Coverage reports available after running `npm test -- --coverage`.

## Next Steps

1. Run existing tests: `npm test`
2. Review coverage: `npm test -- --coverage`
3. Read TODO items in test files to see what needs implementation
4. Implement prioritized tests (Player → YouTube → Keys)
5. Add integration tests for complete user flows
