<?php

namespace Drupal\tv\Controller;

use Drupal\Core\Controller\ControllerBase;
use Drupal\Core\DependencyInjection\ContainerInjectionInterface;
use Drupal\node\NodeInterface;
use Drupal\tv\Brand\TvBrandCollector;
use Drupal\tv\Entity\TvChannel;
use Drupal\tv\Service\TvChannelServiceInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;

/**
 * Returns responses for Node routes.
 */
class TvChannelController extends ControllerBase implements ContainerInjectionInterface {

    protected TvChannelServiceInterface $channelService;
    protected TvBrandCollector $brandCollector;

    public function __construct(TvChannelServiceInterface $channelService, TvBrandCollector $brandCollector) {
        $this->channelService = $channelService;
        $this->brandCollector = $brandCollector;
    }

    public static function create(ContainerInterface $container): static {
        return new static(
            $container->get('tv.channel'),
            $container->get('tv.brand_collector')
        );
    }

    public function getChannel(NodeInterface $node): JsonResponse
    {
        // @todo update function signature to: getItems(TvChannel $channel): JsonResponse
        $channel = (new TvChannel($this->entityTypeManager()))->load($node->id());

        // Get brand from field_brand on the node, fallback to injected default.
        $brand = NULL;
        if ($node->hasField('field_brand') && !$node->get('field_brand')->isEmpty()) {
            $brand = $node->get('field_brand')->value;
        }
        if (empty($brand)) {
            $brand = $this->brandCollector->getBrand();
        }

        return new JsonResponse([
            'title' => $node->getTitle(),
            'method' => 'GET',
            'status'=> 200,
            'autoplay' => $this->channelService->getAutoPlayPreference(),
            'mute' => $this->channelService->getMutePreference(),
            'playlist' => $this->channelService->getItems($channel),
            'brand' => $brand,
        ], 200);
    }

}
