<?php

declare(strict_types=1);

namespace Drupal\twenty_crm\Plugin\GraphQLCompose\SchemaType;

use Drupal\graphql_compose\Plugin\GraphQLCompose\GraphQLComposeSchemaTypeBase;
use GraphQL\Type\Definition\ObjectType;
use GraphQL\Type\Definition\Type;

/**
 * {@inheritDoc}
 *
 * @GraphQLComposeSchemaType(
 *   id = "TwentyCrmShared",
 * )
 */
class TwentyCrmSharedSchemaType extends GraphQLComposeSchemaTypeBase {

  /**
   * {@inheritDoc}
   */
  public function getTypes(): array {
    $types = [];

    // Add the link type.
    $types[] = new ObjectType([
      'name' => 'TwentyCrmLink',
      'description' => (string) $this->t('A Twenty CRM link.'),
      'fields' => fn() => [
        'url' => Type::string(),
        'label' => Type::string(),
      ],
    ]);

    // Add the link collection type.
    $types[] = new ObjectType([
      'name' => 'TwentyCrmLinkCollection',
      'description' => (string) $this->t('A collection of Twenty CRM links.'),
      'fields' => fn() => [
        'primaryLink' => $this->gqlSchemaTypeManager->get('TwentyCrmLink'),
        'secondaryLinks' => Type::listOf($this->gqlSchemaTypeManager->get('TwentyCrmLink')),
      ],
    ]);

    // Add the company type.
    $types[] = new ObjectType([
      'name' => 'TwentyCrmCompany',
      'description' => (string) $this->t('A Twenty CRM company.'),
      'fields' => fn() => [
        'id' => Type::string(),
        'name' => Type::string(),
        'domainName' => $this->gqlSchemaTypeManager->get('TwentyCrmLinkCollection'),
        'facebook' => $this->gqlSchemaTypeManager->get('TwentyCrmLinkCollection'),
        'linkedinLink' => $this->gqlSchemaTypeManager->get('TwentyCrmLinkCollection'),
        'xLink' => $this->gqlSchemaTypeManager->get('TwentyCrmLinkCollection'),
        'addressCity' => Type::string(),
        'addressCountry' => Type::string(),
        'addressStreet1' => Type::string(),
        'addressStreet2' => Type::string(),
        'addressState' => Type::string(),
        'addressPostcode' => Type::string(),
        'employees' => Type::int(),
        'locationString' => Type::string(),
// JSON string representation.
        'customFields' => Type::string(),
        'createdAt' => Type::string(),
        'updatedAt' => Type::string(),
      ],
    ]);

    // Add the contact type.
    $types[] = new ObjectType([
      'name' => 'TwentyCrmContact',
      'description' => (string) $this->t('A Twenty CRM contact.'),
      'fields' => fn() => [
        'id' => Type::string(),
        'email' => Type::string(),
        'firstName' => Type::string(),
        'lastName' => Type::string(),
        'fullName' => Type::string(),
        'phone' => Type::string(),
        'jobTitle' => Type::string(),
        'companyId' => Type::string(),
// JSON string representation.
        'customFields' => Type::string(),
        'createdAt' => Type::string(),
        'updatedAt' => Type::string(),
      ],
    ]);

    return $types;
  }

}
