<?php

declare(strict_types=1);

namespace Drupal\twenty_crm\Plugin\GraphQLCompose\SchemaType;

use Drupal\graphql_compose\Plugin\GraphQLCompose\GraphQLComposeSchemaTypeBase;
use GraphQL\Type\Definition\ObjectType;
use GraphQL\Type\Definition\Type;

/**
 * {@inheritDoc}
 *
 * @GraphQLComposeSchemaType(
 *   id = "TwentyCrmCompanyReference",
 * )
 */
class TwentyCrmCompanyReferenceSchemaType extends GraphQLComposeSchemaTypeBase {

  /**
   * {@inheritDoc}
   */
  public function getTypes(): array {
    $types = [];

    // Add the main company reference type.
    // The TwentyCrmCompany type is defined in TwentyCrmSharedSchemaType
    $types[] = new ObjectType([
      'name' => $this->getPluginId(),
      'description' => (string) $this->t('A Twenty CRM company reference.'),
      'fields' => fn() => [
        'companyUuid' => Type::string(),
        'companyName' => Type::string(),
        'companyCity' => Type::string(),
        'companyCountry' => Type::string(),
        'company' => $this->gqlSchemaTypeManager->get('TwentyCrmCompany'),
      ],
    ]);

    return $types;
  }

}