<?php

declare(strict_types=1);

namespace Drupal\twenty_crm\Plugin\GraphQLCompose\SchemaType;

use Drupal\graphql_compose\Plugin\GraphQLCompose\GraphQLComposeSchemaTypeBase;
use GraphQL\Type\Definition\ObjectType;
use GraphQL\Type\Definition\Type;

/**
 * {@inheritDoc}
 *
 * @GraphQLComposeSchemaType(
 *   id = "TwentyCrmCustomerReference",
 * )
 */
class TwentyCrmCustomerReferenceSchemaType extends GraphQLComposeSchemaTypeBase {

  /**
   * {@inheritDoc}
   */
  public function getTypes(): array {
    $types = [];

    // Add the main customer reference type.
    // The TwentyCrmContact and TwentyCrmCompany types are defined in TwentyCrmSharedSchemaType
    $types[] = new ObjectType([
      'name' => $this->getPluginId(),
      'description' => (string) $this->t('A Twenty CRM customer reference.'),
      'fields' => fn() => [
        'contactUuid' => Type::string(),
        'companyUuid' => Type::string(),
        'companyName' => Type::string(),
        'contactName' => Type::string(),
        'contact' => $this->gqlSchemaTypeManager->get('TwentyCrmContact'),
        'company' => $this->gqlSchemaTypeManager->get('TwentyCrmCompany'),
      ],
    ]);

    return $types;
  }

}