<?php

namespace Drupal\twitterlogin\Plugin\Block;

use Drupal\block\Annotation\Block;
use Drupal\block\Annotation\Translation;
use Drupal\Core\Block\BlockBase;
use Drupal\Core\Url;
use Drupal\user\Entity\User;
use Symfony\Component\HttpFoundation\RedirectResponse;

use Drupal\twitterlogin\Plugin\Network\TwitterOAuth;

/**
 * Provides a Header Menu Block
 *
 * @Block(
 *   id = "twitter_login_block",
 *   admin_label = @Translation("Twitter Login"),
 *   category = @Translation("Blocks")
 * )
 */

class TwitterLoginBlock extends BlockBase {  

  /**
   * {@inheritdoc}
   */
  public function build() {
    $TwitterauthUrl = 'Empty Content';
    $icon_url = '';

    $consumerKey = \Drupal::config('twitterlogin.settings')->get('consumer_key');
    $consumerSecret = \Drupal::config('twitterlogin.settings')->get('consumer_secret');
    $redirectURL = \Drupal::config('twitterlogin.settings')->get('redirect_url');

    if ($consumerKey =='' || $consumerSecret =='' || $redirectURL =='' ) {
      drupal_set_message($this->t('Please Provide Valid Twitter OAUTH API'), 'error');
    }

    //If OAuth token not matched.
    if (isset($_REQUEST['oauth_token']) && $_SESSION['token'] !== $_REQUEST['oauth_token']) {
      //Remove token from session.
      unset($_SESSION['token']);
      unset($_SESSION['token_secret']);
    }

    //If user already verified.
    if (isset($_SESSION['status']) && $_SESSION['status'] == 'verified' && !empty($_SESSION['request_vars'])) {
      // Load the current user.
      $user = User::load(\Drupal::currentUser()->id());
      $email = $user->get('mail')->value;
      return [
      '#markup' => $email,
        '#cache'  => [
          'max-age' => 0,
        ],
      ];
    }
    elseif (isset($_REQUEST['oauth_token']) && $_SESSION['token'] == $_REQUEST['oauth_token']) {
      $token = $_SESSION['token'];
      $token_secret = $_SESSION['token_secret'];
      $userInfo = TwitterOAuth::accessTokenTwitter($consumerKey, $consumerSecret, $token, $token_secret);
      if($userInfo == '404') {
        $TwitterauthUrl = $icon_url;
        drupal_set_message($this->t('Please Provide Valid Twitter OAUTH API'), 'error');
        return [
          '#markup' => $TwitterauthUrl,
          '#cache'  => [
            'max-age' => 0,
          ],
        ];
        return false;
      }
      else {
        TwitterOAuth::social_login_twitter_login($userInfo);  
      }      
    }
    else {
      $auth_url = TwitterOAuth::requestToken($consumerKey, $consumerSecret, $redirectURL);

      $display = \Drupal::config('twitterlogin.icon.settings')->get('display');
      $display_url = \Drupal::config('twitterlogin.icon.settings')->get('display_url');

      $path = drupal_get_path('module', 'twitterlogin');

      if (isset($display_url) && $display_url!='') {
        $icon_url = '<img src = '.$display_url.' />';
      }
      else {
        if ($display == 0) {
          $icon_url = '<img src = "/'. $path .'/images/sign-in-with-twitter.png" border="0">';
        }
        if ($display == 1) {         
          $icon_url = '<img src = "/'. $path .'/images/twitter-icon.png" border="0">';
        }
      }

      if ($auth_url == '404') {
        $TwitterauthUrl = $icon_url;
        drupal_set_message($this->t('Please Provide Valid Twitter OAUTH API'), 'error');
        return [
          '#markup' => $TwitterauthUrl,
          '#cache'  => [
            'max-age' => 0,
          ],
        ];
        return false;
      }
      else {
        $TwitterauthUrl = '<a href="'. $auth_url .'">'. $icon_url .'</a>';
      }
    }

    return [
      '#markup' => $TwitterauthUrl,
      '#cache'  => [
        'max-age' => 0,
      ],
    ];
  }

}