<?php

namespace Drupal\twitterlogin\Controller;

use Drupal\Core\Controller\ControllerBase;
use Drupal\twitterlogin\Plugin\Network\TwitterOAuth;
use Drupal\user\Entity\User;

/**
 * TwitterUserLoginController class
 */
class TwitterUserLoginController extends ControllerBase{
	/**
   * {@inheritdoc}
   */
	public function twitter_user_login(){
		$this->checkUserExist();
		return $this->redirect('<front>');

	}

	/**
   * {@inheritdoc}
   */
	public function checkUserExist(){
		$token = $_SESSION['token'];
		$token_secret = $_SESSION['token_secret'];
		$config = \Drupal::config('twitterlogin.settings');
		$consumer_key = $config->get('consumer_key');
		$consumer_secret = $config->get('consumer_secret');

		// To get the Access Token.
		TwitterOAuth::accessTokenTwitter($consumerKey, $consumerSecret, $token, $token_secret);
		$request_vars = $_SESSION['request_vars'];
		$oauth_token = $request_vars['oauth_token'];
		$oauth_token_secret = $request_vars['oauth_token_secret'];
		$request_token = $_REQUEST['oauth_token'];
		$request_verifier = $_REQUEST['oauth_verifier'];
		$user_id = $request_vars['user_id'];
		$user_name = $request_vars['screen_name'];
		
		if (!empty($request_token) && $token == $request_token) {
			$userInfo = user_load_by_name($user_name); 
			if (empty($userInfo)) {
				$userCreation = User::create(array(
					'name'=> $user_name,
					'mail'=> $user_name . '@gmail.com',
					'password'=> FALSE,
					'status' => 1
					));
				$userCreation->save();
				$userInfo = user_load_by_name($user_name);
				user_login_finalize($userInfo);
			}
			else {
				user_login_finalize($userInfo);
			}
		}
		else {
			drupal_set_message(t('Please Provide Valid Twitter OAUTH API'), 'error');
		}
	}

}
