<?php

namespace Drupal\twitterlogin\Plugin\Block;

//require_once('TokenRequest.php');

use Drupal\block\Annotation\Block;
use Drupal\block\Annotation\Translation;
use Drupal\Core\Block\BlockBase;
use Drupal\Core\Url;
use Symfony\Component\HttpFoundation\RedirectResponse;

use Drupal\twitterlogin\Plugin\Network\OAuthException;
use Drupal\twitterlogin\Plugin\Network\OAuthConsumer;
use Drupal\twitterlogin\Plugin\Network\OAuthToken;
use Drupal\twitterlogin\Plugin\Network\OAuthSignatureMethod;
use Drupal\twitterlogin\Plugin\Network\OAuthSignatureMethod_HMAC_SHA1;
use Drupal\twitterlogin\Plugin\Network\OAuthSignatureMethod_PLAINTEXT;
use Drupal\twitterlogin\Plugin\Network\OAuthSignatureMethod_RSA_SHA1;
use Drupal\twitterlogin\Plugin\Network\OAuthRequest;
use Drupal\twitterlogin\Plugin\Network\OAuthServer;
use Drupal\twitterlogin\Plugin\Network\OAuthDataStore;
use Drupal\twitterlogin\Plugin\Network\OAuthUtil;
use Drupal\twitterlogin\Plugin\Network\TwitterOAuth;

/**
 * Provides a Header Menu Block
 *
 * @Block(
 *   id = "twitter_login_block",
 *   admin_label = @Translation("Twitter Login"),
 *   category = @Translation("Blocks")
 * )
 */

class TwitterLoginBlock extends BlockBase {  

  public function build() {
    global $base_url;
    $TwitterauthUrl = 'Empty Content';

    $consumerKey = \Drupal::config('twitterlogin.settings')->get('consumer_key');
    $consumerSecret = \Drupal::config('twitterlogin.settings')->get('consumer_secret');
    $redirectURL = \Drupal::config('twitterlogin.settings')->get('redirect_url');

    if($consumerKey =='' || $consumerSecret =='' || $redirectURL =='' ) {
      drupal_set_message(t('Please Provide Valid Twitter OAUTH API'), 'error');
    }

    //If OAuth token not matched
    if(isset($_REQUEST['oauth_token']) && $_SESSION['token'] !== $_REQUEST['oauth_token']){
      //Remove token from session
      unset($_SESSION['token']);
      unset($_SESSION['token_secret']);
    }

    //If user already verified 
    if(isset($_SESSION['status']) && $_SESSION['status'] == 'verified' && !empty($_SESSION['request_vars'])){
      // Load the current user.
      $user = \Drupal\user\Entity\User::load(\Drupal::currentUser()->id());
      $email = $user->get('mail')->value;
      $name = $user->get('name')->value;
      return array(
      '#markup' => $email,
        '#cache'  => array(
          'max-age' => 0,
        ),
      );
    }
    elseif(isset($_REQUEST['oauth_token']) && $_SESSION['token'] == $_REQUEST['oauth_token']){
      $token = $_SESSION['token'];
      $token_secret = $_SESSION['token_secret'];
      $userInfo = TwitterOAuth::accessTokenTwitter($consumerKey, $consumerSecret, $token, $token_secret);
      TwitterOAuth::social_login_twitter_login($userInfo);
    }
    else{
      $auth_url = TwitterOAuth::requestToken($consumerKey,$consumerSecret,$redirectURL);

      $display = \Drupal::config('twitterlogin.icon.settings')->get('display');
      $display_url = \Drupal::config('twitterlogin.icon.settings')->get('display_url');

      $path = drupal_get_path('module', 'twitterlogin');

      if(isset($display_url) && $display_url!=''){
        $icon_url = '<img src = '.$display_url.' />';
      }
      else {
        if($display == 0) {
          $icon_url = '<img src = "/'.$path.'/images/sign-in-with-twitter.png" border="0">';
        }
        if($display == 1) {         
          $icon_url = '<img src = "/'.$path.'/images/twitter-icon.png" border="0">';
        }
      }

      if($auth_url == '404') {
        $TwitterauthUrl = $icon_url;
        drupal_set_message(t('Please Provide Valid Twitter OAUTH API'), 'error');
        return array(
          '#markup' => $TwitterauthUrl,
          '#cache'  => array(
            'max-age' => 0,
          ),
        );
        return false;
      }
      else {
        $TwitterauthUrl = '<a href="'.$auth_url.'">'.$icon_url.'</a>';
      }
    }

    return array(
      '#markup' => $TwitterauthUrl,
      '#cache'  => array(
        'max-age' => 0,
      ),
    );
  }
}