<?php

namespace Drupal\typed_entity_example\Plugin\TypedRepositories;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\typed_entity\Attribute\TypedRepository;
use Drupal\typed_entity\ClassWithVariants;
use Drupal\typed_entity\TypedRepositories\TypedRepositoryBase;
use Drupal\typed_entity_example\WrappedEntities\User;

/**
 * The repository for articles.
 */
#[TypedRepository(
  entity_type_id: 'user',
  description: new TranslatableMarkup('Repository that holds business logic applicable to all users.'),
  wrappers: new ClassWithVariants(User::class),
)]
final class UserRepository extends TypedRepositoryBase {}
