<?php

namespace Drupal\typed_entity\Attribute;

use Drupal\Component\Plugin\Attribute\Plugin;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\typed_entity\ClassWithVariantsInterface;
use Drupal\typed_entity\TypedRepositories\TypedRepositoryBase;

/**
 * Defines a TypedRepository attribute object.
 */
#[\Attribute(\Attribute::TARGET_CLASS)]
class TypedRepository extends Plugin {

  /**
   * Constructs a TypedRepository attribute instance.
   *
   * @param string $entity_type_id
   *   The entity type ID.
   * @param string|null $bundle
   *   (optional) The bundle.
   * @param \Drupal\Core\StringTranslation\TranslatableMarkup|null $description
   *   (optional) The description of the plugin.
   * @param \Drupal\typed_entity\ClassWithVariantsInterface|null $wrappers
   *   (optional) The available wrappers.
   * @param \Drupal\typed_entity\ClassWithVariantsInterface|null $renderers
   *   (optional) The available renderers.
   */
  public function __construct(
    public readonly string $entity_type_id,
    public readonly ?string $bundle = NULL,
    public readonly ?TranslatableMarkup $description = NULL,
    public readonly ?ClassWithVariantsInterface $wrappers = NULL,
    public readonly ?ClassWithVariantsInterface $renderers = NULL,
  ) {}

  /**
   * {@inheritdoc}
   */
  public function getId(): string {
    return $this->id
      ?? TypedRepositoryBase::generatePluginId(
        $this->entity_type_id ?? '',
        $this->bundle ?? '',
      );
  }

}
