<?php

namespace Drupal\typed_entity_test\Plugin\TypedRepositories;

use Drupal\typed_entity\Attribute\TypedRepository;
use Drupal\typed_entity\ClassWithVariants;
use Drupal\typed_entity\TypedRepositories\TypedRepositoryBase;
use Drupal\typed_entity_test\Render\Article\ConditionalRenderer;
use Drupal\typed_entity_test\Render\Article\Teaser;
use Drupal\typed_entity_test\WrappedEntities\Article;
use Drupal\typed_entity_test\WrappedEntities\NewsArticle;

/**
 * The repository for articles.
 */
#[TypedRepository(
  entity_type_id: 'node',
  bundle: 'article',
  wrappers: new ClassWithVariants(Article::class, [NewsArticle::class]),
  renderers: new ClassWithVariants(variants: [
    Teaser::class,
    ConditionalRenderer::class,
  ]),
)]
final class ArticleRepository extends TypedRepositoryBase {}
