<?php

declare(strict_types=1);

namespace Drupal\typesense_graphql\Plugin\GraphQL\DataProducer;

use Drupal\graphql\Plugin\GraphQL\DataProducer\DataProducerPluginBase;

/**
 * Produces a highlight for a specific field.
 *
 * @DataProducer(
 *   id = "typesense_graphql_highlight_get_highlight",
 *   name = "Typesense Get Highlight",
 *   description = @Translation("Produce a highlight for a specific field"),
 *   produces = @ContextDefinition("any",
 *     label = @Translation("The highlight")
 *   ),
 *   consumes = {
 *     "highlights" = @ContextDefinition("any",
 *       label = @Translation("The highlights object"),
 *     ),
 *     "field" = @ContextDefinition("string",
 *       label = @Translation("The field name"),
 *     ),
 *   }
 * )
 */
final class TypesenseHighlightGetHighlight extends DataProducerPluginBase {

  /**
   * Resolves the highlight for a specific field.
   *
   * @param array $highlights
   *   The highlights object.
   * @param string $field
   *   The field name.
   *
   * @return array|null
   *   The highlight if found.
   */
  protected function resolve(array $highlights, string $field): array|null {
    $hit = $highlights['hit'] ?? [];
    $highlights_data = $hit['highlights'] ?? [];

    foreach ($highlights_data as $highlight) {
      $fieldName = $highlight['field'] ?? NULL;

      if ($fieldName === $field) {
        return $highlight;
      }
    }

    return NULL;
  }

}
