<?php

declare(strict_types=1);

namespace Drupal\typesense_graphql\Enum;

/**
 * Enumerates the available facet types.
 */
enum TypesenseFacetType: string implements GraphQlEnumTypeInterface {

  case EntityReferenceObject = 'entity_reference_object';
  case String = 'string';

  /**
   * {@inheritdoc}
   */
  public function toGraphQlEnumValue(): string {
    return strtoupper($this->value);
  }

}
