<?php

declare(strict_types=1);

namespace Drupal\typesense_graphql\Plugin\GraphQL\DataProducer;

use Drupal\typesense_graphql\Model\TypesenseMultiSearchResponse;
use Drupal\graphql\Plugin\GraphQL\DataProducer\DataProducerPluginBase;

/**
 * Produces the search hits.
 *
 * @DataProducer(
 *   id = "typesense_graphql_total",
 *   name = "Search Typesense Total",
 *   description = @Translation("Produce the total hit count"),
 *   produces = @ContextDefinition("any",
 *     label = @Translation("The hit count")
 *   ),
 *   consumes = {
 *     "response" = @ContextDefinition("any",
 *       label = @Translation("The Typesense multiSearch response"),
 *     ),
 *   }
 * )
 */
final class TypesenseTotal extends DataProducerPluginBase {

  /**
   * Resolves the total hit count.
   *
   * @param \Drupal\typesense_graphql\Model\TypesenseMultiSearchResponse $response
   *   An Typesense multiSearch response.
   *
   * @return int
   *   The total hit count.
   */
  protected function resolve(TypesenseMultiSearchResponse $response): int {
    return $response->getTotal();
  }

}
