<?php

declare(strict_types=1);

namespace Drupal\typesense_graphql\Plugin\GraphQL\DataProducer;

use Drupal\graphql\Plugin\GraphQL\DataProducer\DataProducerPluginBase;

/**
 * Produces the highlights object.
 *
 * @DataProducer(
 *   id = "typesense_graphql_highlights",
 *   name = "Typesense Highlights",
 *   description = @Translation("Produce the highlights object"),
 *   produces = @ContextDefinition("any",
 *     label = @Translation("The highlights")
 *   ),
 *   consumes = {
 *     "hit" = @ContextDefinition("any",
 *       label = @Translation("The Typesense hit"),
 *     ),
 *   }
 * )
 */
final class TypesenseHighlights extends DataProducerPluginBase {

  /**
   * Resolves the highlights object.
   *
   * @param array $hit
   *   The Typesense hit.
   *
   * @return array
   *   The highlights object.
   */
  protected function resolve(array $hit): array {
    return [
      'hit' => $hit,
    ];
  }

}
