<?php

declare(strict_types=1);

namespace Drupal\typesense_graphql\Plugin\search_api\data_type;

/**
 * Provides a Typesense array data type to index date arrays.
 *
 * @SearchApiDataType(
 *   id = "typesense_date_time[]",
 *   label = @Translation("Typesense: Date / Date Time Array"),
 *   description = @Translation("Support for multi-value date_time and date fields."),
 *   fallback_type = "typesense_int64[]"
 * )
 */
class DateTimeMulti extends DateTime {

  /**
   * {@inheritdoc}
   */
  public function alterSchemaField(array $field): array {
    // Typesense expects date and date_time fields to be stored as int64 (epoch time).
    // For arrays, we use int64[].
    $field['type'] = 'int64[]';
    return $field;
  }

}
