<?php

declare(strict_types=1);

namespace Drupal\typesense_graphql\Plugin\search_api\data_type;

use Drupal\typesense_graphql\Plugin\search_api\EntityReferenceObjectDataTypeInterface;
use Drupal\typesense_graphql\TypesenseSchemaAwareInterface;

/**
 * Provides a data type for "node" entity reference objects.
 *
 * @SearchApiDataType(
 *   id = "typesense_entity_reference_object_node[]",
 *   label = @Translation("Typesense: Entity Reference Object (Node)"),
 *   description = @Translation("A node entity reference object."),
 * )
 */
class EntityReferenceObjectNode extends EntityReferenceObjectTaxonomyTerm implements EntityReferenceObjectDataTypeInterface, TypesenseSchemaAwareInterface {

  /**
   * {@inheritdoc}
   */
  public function getEntityTypeId(): string {
    return 'node';
  }

}
