<?php

declare(strict_types=1);

namespace Drupal\typesense_graphql\Plugin\search_api\data_type;

use Drupal\search_api\DataType\DataTypePluginBase;
use Drupal\typesense_graphql\TypesenseSchemaAwareInterface;

/**
 * Provides a data type for KeyValue objects.
 *
 * @SearchApiDataType(
 *   id = "typesense_key_value[]",
 *   label = @Translation("Typesense: Key Value"),
 *   description = @Translation("A key-value object with id and label properties."),
 * )
 */
class KeyValue extends DataTypePluginBase implements TypesenseSchemaAwareInterface {

  /**
   * {@inheritdoc}
   */
  public function alterSchemaField(array $field): array {
    // KeyValue objects should be stored as object[] in Typesense.
    $field['type'] = 'object[]';
    return $field;
  }

  /**
   * {@inheritdoc}
   */
  public function addAdditionalFields(array $field): array {
    $fieldName = $field['name'];
    $additionalFields = [];

    // We explicitly declare e.g. "field_bundle.id" as field, because we need to
    // create facets on it.
    $additionalFields[] = [
      'name' => $fieldName . '.id',
      'type' => 'string[]',
      'facet' => TRUE,
      'optional' => TRUE,
      'index' => TRUE,
    ];

    // Explicitly declare e.g. "field_bundle.label" as a field, because we use it
    // for fulltext search.
    $additionalFields[] = [
      'name' => $fieldName . '.label',
      'type' => 'string[]',
      'locale' => 'en',
      'facet' => FALSE,
      'optional' => TRUE,
      'index' => TRUE,
      'infix' => TRUE,
    ];

    return $additionalFields;
  }

}
