<?php

namespace Drupal\typesense_graphql;

/**
 * Interface for altering Typesense schema fields.
 */
interface TypesenseSchemaAwareInterface {

  /**
   * Alters a field in the Typesense schema.
   *
   * @param array $field
   *   The field definition array.
   *
   * @return array
   *   The altered field definition array.
   */
  public function alterSchemaField(array $field): array;

  /**
   * Returns additional fields that should be added to the schema.
   *
   * @param array $field
   *   The original field definition array.
   *
   * @return array
   *   Array of additional field definitions to add to the schema.
   */
  public function addAdditionalFields(array $field): array;

}
