<?php

declare(strict_types=1);

namespace Drupal\typesense_graphql\Enum;

/**
 * Enumerates the available sort directions.
 */
enum TypesenseSortDirection: string implements GraphQlEnumTypeInterface {

  case Asc = 'asc';
  case Desc = 'desc';

  /**
   * {@inheritdoc}
   */
  public function toGraphQlEnumValue(): string {
    return strtoupper($this->value);
  }

}

