<?php

declare(strict_types=1);

namespace Drupal\typesense_graphql\Enum;

/**
 * Interface to convert an enum value to a GraphQL type.
 */
interface GraphQlEnumTypeInterface {

  /**
   * Returns the GraphQL enum value.
   *
   * The standard for enums in GraphQL is to use UPPER_SNAKE_CASE.
   *
   * @return string
   *   The GraphQL enum value.
   */
  public function toGraphQlEnumValue(): string;

}
