<?php

declare(strict_types=1);

namespace Drupal\typesense_graphql\Enum;

/**
 * Enumerates the available search modes.
 */
enum TypesenseSearchMode: string implements GraphQlEnumTypeInterface {

  case KeywordSearch = 'keyword_search';
  case SemanticSearch = 'semantic_search';
  case HybridSearch = 'hybrid_search';

  /**
   * {@inheritdoc}
   */
  public function toGraphQlEnumValue(): string {
    return strtoupper($this->value);
  }

}
