<?php

declare(strict_types=1);

namespace Drupal\typesense_graphql\Plugin\GraphQL\DataProducer;

use Drupal\typesense_graphql\Model\TypesenseMultiSearchResponse;
use Drupal\graphql\Plugin\GraphQL\DataProducer\DataProducerPluginBase;

/**
 * Produces the search hits.
 *
 * @DataProducer(
 *   id = "typesense_graphql_hits",
 *   name = "EKW: Search Typesense Hits",
 *   description = @Translation("Produce the hits"),
 *   produces = @ContextDefinition("any",
 *     label = @Translation("The hits")
 *   ),
 *   consumes = {
 *     "response" = @ContextDefinition("any",
 *       label = @Translation("The Typesense multiSearch response"),
 *     ),
 *   }
 * )
 */
final class TypesenseHits extends DataProducerPluginBase {

  /**
   * Resolves the search results.
   *
   * @param \Drupal\typesense_graphql\Model\TypesenseMultiSearchResponse $response
   *   An Typesense multiSearch response.
   *
   * @return array
   *   The hits.
   */
  protected function resolve(TypesenseMultiSearchResponse $response): array {
    return $response->getHits();
  }

}
