<?php

declare(strict_types=1);

namespace Drupal\typesense_graphql\Plugin\search_api\data_type;

use Drupal\search_api\DataType\DataTypePluginBase;
use Drupal\typesense_graphql\TypesenseSchemaAwareInterface;

/**
 * Provides a Typesense object data type to index dates.
 *
 * @SearchApiDataType(
 *   id = "typesense_date_time",
 *   label = @Translation("Typesense: Date / Date Time"),
 *   description = @Translation("Support for date_time and date fields."),
 *   fallback_type = "typesense_int64"
 * )
 */
class DateTime extends DataTypePluginBase implements TypesenseSchemaAwareInterface {

  /**
   * {@inheritdoc}
   */
  public function getValue($value) {
    if (!$value) {
      return NULL;
    }

    // Detect epoch string
    if (is_string($value) && preg_match('/^\d{10,}$/', $value)) {
      // Convert epoch string to integer.
      $epoch = (int) $value;
      return $epoch;
    }

    // Handle date fields, which are stored as strings
    if (is_string($value)) {
      // Convert date string to timestamp.
      $timestamp = strtotime($value);
      if ($timestamp === FALSE) {
        // Invalid date string.
        return NULL;
      }
      return $timestamp;
    }

    return NULL;
  }

  public function alterSchemaField(array $field): array {
    // Typesense expects date and date_time fields to be stored as int64 (epoch time).
    $field['type'] = 'int64';
    return $field;
  }

  /**
   * {@inheritdoc}
   */
  public function addAdditionalFields(array $field): array {
    return [];
  }

}
