# Ubercart Product Redeem (`uc_product_redeem`)

Drupal 7 module to redeem (and unredeem) **Ubercart** products used as events, audit logging, and a canonical redeem page.

---

## Highlights

- Canonical redeem page: `/product-redeem/{order_id}/redeem` (+ admin tab)
- Per-line **partial** redeem/unredeem, with quick “Redeem 1 / Unredeem 1” (optional)
- **Append-only** audit log in `uc_product_redeem` (`qty > 0` redeem, `qty < 0` unredeem)
- **Auto status**: when the last unit across the order is redeemed, the order is set to **`redeemed`** (ignores any “filter to now” UI)
- Collapsible **Order comments** (read-only) and **Add note** panel (writes one comment)
- Legacy link interception: old `/ticketing/redeem?o=...` → canonical
- Email helper (optional) to generate QR targets consistent with your settings
- Access controls (require login and/or `?ak=access_key` in links)
- Views Integration: Allows the user to use a view for the redemption page &OR create reports with the audit log trail

---

## Requirements

- Drupal 7.x, Ubercart 3.x

---

## Settings

**Store → Configuration → Product redeem**

- **Access control**
  - Require staff login (and restrict by roles)
  - Access key for anonymous links (append `?ak=KEY`)
- **Behavior**
  - Allow partial redemption
  - After an action: stay on page / go to order / none
  - Scan mode (Enter in qty submits the row)
- **Product visibility (date)**
  - Only show items valid for the current date/time
  - Date field machine name (`field_date` by default)
- **Display**
  - Page title / Intro text
  - Show prices
  - Show **Redeemed** column
  - Show **Remaining** column
  - Show quick links (“Redeem 1 / Unredeem 1”)
  - Show order comments (and collapse by default)
- **Links**
  - Link mode: Canonical or Legacy
  - Intercept old `/ticketing/redeem` links
- **Logging**
  - Write actions to order comments
  - Include staff IP

> **Note:** Unredeem is always **append-only** (negative entries). There is no “decrement” mode.

---

## How it works

- The table calculates, per line:
  - **Redeemed** = `SUM(qty)` from `uc_product_redeem`
  - **Remaining** = `ordered - redeemed`
- Submitting a row appends a new entry; totals are recomputed.
- After each change, the module checks **all order products** (ignoring UI filters).  
  If total remaining across the order is **0**, it sets `uc_orders.order_status = 'redeemed'` and writes one comment.

---

## URLs

- Finder: `/product-redeem/search` (enter Order ID)
- Canonical page: `/product-redeem/{order_id}/redeem`
- Admin tab: `admin/store/orders/{order_id}/redeem`
- Legacy redirect: `/ticketing/redeem?o=<rand><order_id*2><rand>&c=<created>[&ak=...]`

---

## Developer API

Documented in `uc_product_redeem.api.php`:

- `hook_uc_product_redeem_apply_context_alter(&$context)`
- `hook_uc_product_redeem_post_apply($result, $context)`
- `hook_uc_product_redeem_comment_message_alter(&$message, $context)`
- `hook_uc_product_redeem_order_fully_redeemed($order_id, $status_changed, $context)`

---

## Limitations

- Drupal 7 / Ubercart 3 only.
- “Fully redeemed” status change is one-way by default (it won’t auto-revert on unredeem unless you implement a custom reaction in a hook).
- If you filter table rows by date/time, the **status check still considers the entire order**, by design.

---

## Install

1. Place the module in `sites/all/modules/uc_product_redeem/`
2. Enable it, configure settings, clear caches.
3. (Optional) Update your email template to use your canonical QR URL.

