<?php
/**
 * @file
 * Default redemption page template.
 *
 * Variables:
 *  - $order: Ubercart order object.
 *  - $items: Array of normalized item objects (title, qty, redeemed, remaining, token, etc.).
 *  - $settings: Array of display/behavior settings.
 *  - $viewable_count: integer.
 *
 * Copy to your theme as: templates/uc-product-redeem-page.tpl.php to override.
 */
?>
<div class="ucpr">

  <header class="ucpr__header">
    <h1 class="ucpr__title">
      <?php print check_plain(menu_get_active_title()); ?>
    </h1>

    <details class="ucpr__order-details">
      <summary><?php print t('Order Details'); ?></summary>
      <div class="ucpr__meta">
        <div><strong><?php print t('Order ID'); ?>:</strong> <?php print l($order->order_id, 'admin/store/orders/' . $order->order_id); ?></div>
        <?php if (!empty($order->billing_first_name) || !empty($order->billing_last_name)): ?>
          <div><strong><?php print t('Name'); ?>:</strong> <?php print check_plain(trim($order->billing_first_name . ' ' . $order->billing_last_name)); ?></div>
        <?php endif; ?>
        <?php if (!empty($order->primary_email)): ?>
          <div><strong><?php print t('Email'); ?>:</strong> <?php print check_plain($order->primary_email); ?></div>
        <?php endif; ?>
        <?php if (!empty($order->created)): ?>
          <div><strong><?php print t('Purchased'); ?>:</strong> <?php print format_date($order->created, 'short'); ?></div>
        <?php endif; ?>
        <?php if (!empty($order->payment_method)): ?>
          <div><strong><?php print t('Payment method'); ?>:</strong> <?php print check_plain($order->payment_method); ?></div>
        <?php endif; ?>
        <div><strong><?php print t('Total'); ?>:</strong> <?php print isset($order->order_total) ? check_plain(uc_currency_format($order->order_total)) : ''; ?></div>
      </div>
    </details>
  </header>

  <?php if ($settings['intro']): ?>
  <details class="ucpr__order-details ucpr__order-additional-details">
    <summary><?php print t('Additional Info'); ?></summary>
    <div class="ucpr__info">
      <div class="ucpr__info-text"><?php print $settings['intro']; ?></div>
    </div>
  </details>
  <?php endif; ?>


  <!-- The per-line table and buttons are rendered by the forms below this template. -->
</div>
