<?php

/**
 * @file
 * Settings form for Ubercart Product Redeem.
 */

/**
 * Admin form.
 */
function uc_product_redeem_settings_form($form, &$form_state) {
  $form['access'] = array(
    '#type' => 'fieldset',
    '#title' => t('Access control'),
    '#collapsible' => true,
    '#collapsed' => true,    
  );

  $form['access']['uc_product_redeem_require_login'] = array(
    '#type' => 'checkbox',
    '#title' => t('Require staff login to redeem'),
    '#default_value' => variable_get('uc_product_redeem_require_login', TRUE),
  );

  $form['access']['uc_product_redeem_roles'] = array(
    '#type' => 'checkboxes',
    '#title' => t('Restrict to specific roles'),
    '#options' => user_roles(TRUE),
    '#default_value' => variable_get('uc_product_redeem_roles', array()),
    '#description' => t('Leave all unchecked to allow any user with permission.'),
    '#states' => array(
      'visible' => array(':input[name="uc_product_redeem_require_login"]' => array('checked' => TRUE)),
    ),
  );

  $form['access']['uc_product_redeem_access_key'] = array(
    '#type' => 'textfield',
    '#title' => t('Access key for links (optional)'),
    '#default_value' => variable_get('uc_product_redeem_access_key', ''),
    '#description' => t('If login is not required, protect redemption URLs with <code>?ak=YOUR_KEY</code>. Leave empty to disable.'),
    '#states' => array(
      'invisible' => array(':input[name="uc_product_redeem_require_login"]' => array('checked' => TRUE)),
    ),
  );

  $form['behavior'] = array(
    '#type' => 'fieldset',
    '#title' => t('Behavior'),
    '#collapsible' => true,
    '#collapsed' => true,    
  );

  $form['behavior']['uc_product_redeem_allow_partial'] = array(
    '#type' => 'checkbox',
    '#title' => t('Allow partial redemption/unredeem on a line item'),
    '#default_value' => variable_get('uc_product_redeem_allow_partial', TRUE),
  );

  $form['behavior']['uc_product_redeem_show_quick_links'] = array(
    '#type' => 'checkbox',
    '#title' => t('Show “Redeem 1 / Unredeem 1” quick links'),
    '#default_value' => variable_get('uc_product_redeem_show_quick_links', FALSE),
    '#states' => array(
      'visible' => array(':input[name="uc_product_redeem_allow_partial"]' => array('checked' => TRUE)),
      'unchecked' => array(':input[name="uc_product_redeem_allow_partial"]' => array('checked' => FALSE)),
    ),
  );

  $form['behavior']['uc_product_redeem_scan_mode'] = array(
    '#type' => 'checkbox',
    '#title' => t('Enable scan mode (press Enter in qty inputs to submit row)'),
    '#description' => t('<em>[dev note: has no effect currently, to be removed if no use for it is found]</em>'),
    '#default_value' => variable_get('uc_product_redeem_scan_mode', FALSE),
  );

  $form['behavior']['uc_product_redeem_allow_notes'] = array(
    '#type' => 'checkbox',
    '#title' => t('Allow notes to be added when redeeming an order.'),
    '#default_value' => variable_get('uc_product_redeem_allow_notes', TRUE),
  );

  $form['behavior']['uc_product_redeem_redirect'] = array(
    '#type' => 'select',
    '#title' => t('After an action'),
    '#options' => array(
      'stay' => t('Stay on redemption page'),
      'order' => t('Go to Ubercart order admin page'),
      'none' => t('No redirect (show message only)'),
    ),
    '#default_value' => variable_get('uc_product_redeem_redirect', 'stay'),
  );

  $form['filtering'] = array(
    '#type' => 'fieldset',
    '#title' => t('Product visibility (date)'),
    '#collapsible' => true,
    '#collapsed' => true,    
  );

  $form['filtering']['uc_product_redeem_filter_to_now'] = array(
    '#type' => 'checkbox',
    '#title' => t('Only show items valid for the current date/time'),
    '#default_value' => variable_get('uc_product_redeem_filter_to_now', FALSE),
    '#description' => t('When enabled, an item is shown only if REQUEST_TIME is between its start and end in the configured date field.'),
  );

  $form['filtering']['uc_product_redeem_date_field'] = array(
    '#type' => 'textfield',
    '#title' => t('Date field machine name'),
    '#default_value' => variable_get('uc_product_redeem_date_field', 'field_date'),
    '#description' => t('Used when filtering to current date/time. If end is missing or equals start, start + 12h is assumed.'),
  );

  $form['display'] = array(
    '#type' => 'fieldset',
    '#title' => t('Display'),
    '#collapsible' => true,
    '#collapsed' => true,
  );

  $form['display']['uc_product_redeem_page_title'] = array(
    '#type' => 'textfield',
    '#title' => t('Page title override'),
    '#default_value' => variable_get('uc_product_redeem_page_title', ''),
  );


  $intro_default = variable_get('uc_product_redeem_page_intro', array('value' => '', 'format' => filter_default_format()));
  $form['display']['uc_product_redeem_page_intro'] = array(
    '#type' => 'text_format',
    '#title' => t('Intro text'),
    '#default_value' => $intro_default['value'],
    '#format' => variable_get('uc_product_redeem_page_intro_format', filter_default_format()),
    '#description' => t('Shown above the items table for instructions/policies.'),
  );
  $form['display']['uc_product_redeem_show_comments'] = array(
    '#type' => 'checkbox',
    '#title' => t('Show order comments on the redeem page'),
    '#default_value' => variable_get('uc_product_redeem_show_comments', TRUE),
  );
  $form['display']['uc_product_redeem_comments_collapsed'] = array(
    '#type' => 'checkbox',
    '#title' => t('Collapse order comments by default'),
    '#default_value' => variable_get('uc_product_redeem_comments_collapsed', TRUE),
    '#states' => array(
      'visible' => array(':input[name="uc_product_redeem_show_comments"]' => array('checked' => TRUE)),
    ),
  );
  $form['display']['uc_product_redeem_show_prices'] = array(
    '#type' => 'checkbox',
    '#title' => t('Show prices on redemption page'),
    '#default_value' => variable_get('uc_product_redeem_show_prices', FALSE),
  );
  $form['display']['uc_product_redeem_show_redeemed'] = array(
    '#type' => 'checkbox',
    '#title' => t('Show redeemed amount on redemption page'),
    '#default_value' => variable_get('uc_product_redeem_show_redeemed', FALSE),
  );
  $form['display']['uc_product_redeem_show_remaining'] = array(
    '#type' => 'checkbox',
    '#title' => t('Show remaining amount to be redeemed on redemption page'),
    '#default_value' => variable_get('uc_product_redeem_show_remaining', FALSE),
  );
  $form['display']['uc_product_redeem_use_views_table'] = array(
    '#type' => 'checkbox',
    '#title' => t('Use a Views display for the redemption items table'),
    '#default_value' => variable_get('uc_product_redeem_use_views_table', FALSE),
    '#description' => t('If enabled, the module will embed the specified Views display on the redeem page instead of the built-in table.'),
  );

  $form['display']['uc_product_redeem_views_table_id'] = array(
    '#type' => 'textfield',
    '#title' => t('Views display for the items table'),
    '#default_value' => variable_get('uc_product_redeem_views_table_id', ''),
    '#size' => 40,
    '#description' => t('Enter as <code>view_machine_name:display_id</code>. The View should accept the order ID as its first contextual filter.'),
    '#states' => array(
      'visible' => array(':input[name="uc_product_redeem_use_views_table"]' => array('checked' => TRUE)),
    ),    
  );

  $form['links'] = array(
    '#type' => 'fieldset',
    '#title' => t('Links'),
    '#collapsible' => true,
    '#collapsed' => true,    
  );

  $form['links']['uc_product_redeem_qr_mode'] = array(
    '#type' => 'select',
    '#title' => t('QR link mode'),
    '#options' => array(
      'canonical' => t('Canonical (/product-redeem/{order_id}/redeem)'),
      'legacy' => t('Legacy (/ticketing/redeem?o=...)'),
    ),
    '#default_value' => variable_get('uc_product_redeem_qr_mode', 'canonical'),
    '#description' => t('Choose which URL style should be used. You can switch back to legacy anytime.'),
  );

  $form['links']['uc_product_redeem_intercept_legacy'] = array(
    '#type' => 'checkbox',
    '#title' => t('Intercept old /ticketing/redeem links and redirect to the new page'),
    '#default_value' => variable_get('uc_product_redeem_intercept_legacy', TRUE),
    '#description' => t('If enabled, existing QR codes that point to /ticketing/redeem will be auto-redirected to the canonical page.'),
  );

  $form['logging'] = array(
    '#type' => 'fieldset',
    '#title' => t('Logging'),
    '#collapsible' => true,
    '#collapsed' => true,    
  );

  $form['logging']['uc_product_redeem_log_comments'] = array(
    '#type' => 'checkbox',
    '#title' => t('Write actions to uc_order_comments'),
    '#default_value' => variable_get('uc_product_redeem_log_comments', TRUE),
  );

  $form['logging']['uc_product_redeem_log_with_ip'] = array(
    '#type' => 'checkbox',
    '#title' => t('Include staff IP address in comments'),
    '#default_value' => variable_get('uc_product_redeem_log_with_ip', TRUE),
    '#states' => array(
      'visible' => array(':input[name="uc_product_redeem_log_comments"]' => array('checked' => TRUE)),
    ),
  );

  $form['#submit'][] = 'uc_product_redeem_settings_form_submit';
  return system_settings_form($form);
}

/**
 * Save text_format fields explicitly.
 */
function uc_product_redeem_settings_form_submit($form, &$form_state) {
  if (isset($form_state['values']['uc_product_redeem_page_intro'])) {
    $tf = $form_state['values']['uc_product_redeem_page_intro'];
    variable_set('uc_product_redeem_page_intro', $tf['value']);
    variable_set('uc_product_redeem_page_intro_format', $tf['format']);
  }
}
