<?php
/**
 * @file
 * Developer hooks for the Ubercart Product Redeem module.
 */

/**
 * Alter the context before a redemption/unredemption is applied.
 *
 * @param array &$context
 *   Keys:
 *   - order (object): Ubercart order.
 *   - order_product (object): uc_order_products row.
 *   - opid (int): order_product_id.
 *   - qty (int): >0 redeem, <0 unredeem (you may adjust).
 *   - mode (string): 'append'|'decrement'.
 *   - context (string): source (e.g., 'inline', 'bulk').
 *   - ip (string), uid (int), account_name (string), timestamp (int).
 */
function hook_uc_product_redeem_apply_context_alter(array &$context) {
  // Example: limit max per action.
  if ($context['qty'] > 10) {
    $context['qty'] = 10;
  }
}

/**
 * React after a redemption/unredemption is applied.
 *
 * @param bool  $result   
 *  TRUE on success.
 * @param array $context  
 *  Same structure as in the *_apply_context_alter hook.
 */
function hook_uc_product_redeem_post_apply($result, array $context) {
  if ($result) {
    watchdog('my_module', 'Redeem change @qty for opid @opid', array('@qty' => $context['qty'], '@opid' => $context['opid']));
  }
}

/**
 * Alter the items list before rendering.
 *
 * @param array &$items  
 *  List of objects with qty, redeemed, remaining, title, etc.
 * @param object $order
 * @param array $settings
 */
function hook_uc_product_redeem_order_items_alter(array &$items, $order, array $settings) {
  // Example: hide items with model 'X'.
  $items = array_values(array_filter($items, function($it) {
    return $it->model !== 'X';
  }));
}

/**
 * Alter the order comment message text right before insert.
 *
 * @param string &$message
 * @param array  $context
 */
function hook_uc_product_redeem_comment_message_alter(&$message, array $context) {
  $message .= ' [via kiosk]';
}

/**
 * Alter the generated QR URL.
 *
 * @param string &$url
 * @param object $order
 * @param string $mode      
 *  'canonical'|'legacy'
 * @param bool   $absolute
 */
function hook_uc_product_redeem_qr_url_alter(&$url, $order, $mode, $absolute) {
  // Append a UTM or switch host.
  $url .= (strpos($url, '?') === FALSE ? '?' : '&') . 'utm_source=qr';
}
