/**
 * @file
 * Small helpers for the redemption page.
 */
(function (Drupal, document) {
  'use strict';

  Drupal.behaviors.ucProductRedeem = {
    attach: function (context) {
      // Scan mode: hitting Enter in qty inputs submits that row's Apply button.
      var scanEnabled = !!document.querySelector('[data-scan-submit]');
      if (scanEnabled) {
        var qtyInputs = context.querySelectorAll('input.ucpr-qty');
        for (var i = 0; i < qtyInputs.length; i++) {
          qtyInputs[i].addEventListener('keydown', function (e) {
            if (e.key === 'Enter') {
              e.preventDefault();
              var form = this.form || this.closest('form');
              if (!form) return;
              var btns = form.querySelectorAll('input[type="submit"], button[type="submit"]');
              if (btns.length) {
                // Prefer the "Apply" (last) button.
                btns[btns.length - 1].click();
              }
            }
          });
        }
      }
    }
  };

})(Drupal, document);
