<?php

/**
 * @file
 * Views integration: expose uc_product_redeem to Views and add a field on
 * uc_order_products for quick redeem links.
 */

/**
 * Implements hook_views_data().
 */
function uc_product_redeem_views_data() {
  $data = array();

  // Register our table so it can be a base and/or related through a relationship.
  $data['uc_product_redeem']['table'] = array(
    'group' => t('Ubercart Product Redeem'),
    'provider' => 'uc_product_redeem',
  );

  // Primary key (adjust if your schema uses a different name).
  if (db_table_exists('uc_product_redeem')) {
    $schema = drupal_get_schema('uc_product_redeem');
    if (!empty($schema['primary key'][0])) {
      $data['uc_product_redeem'][$schema['primary key'][0]] = array(
        'title' => t('Event ID'),
        'help'  => t('Primary key of the redemption event.'),
        'field' => array('handler' => 'views_handler_field'),
        'filter'=> array('handler' => 'views_handler_filter_numeric'),
        'sort'  => array('handler' => 'views_handler_sort'),
      );
    }
  }

  // Fields from our table.
  $data['uc_product_redeem']['order_id'] = array(
    'title' => t('Redeem: Order ID'),
    'help'  => t('Order ID for the redeem record.'),
    'field' => array(
      'handler' => 'views_handler_field_numeric',
      'click sortable' => TRUE,
    ),
    'filter' => array('handler' => 'views_handler_filter_numeric'),
    'sort'   => array('handler' => 'views_handler_sort'),
  );

  $data['uc_product_redeem']['order_product_id'] = array(
    'title' => t('Redeem: Order Product ID'),
    'help'  => t('Order product ID for the redeem record.'),
    'field' => array(
      'handler' => 'views_handler_field_numeric',
      'click sortable' => TRUE,
    ),
    'filter' => array('handler' => 'views_handler_filter_numeric'),
    'sort'   => array('handler' => 'views_handler_sort'),
  );

  $data['uc_product_redeem']['qty'] = array(
    'title' => t('Redeem delta (qty)'),
    'help'  => t('Positive for redeem, negative for unredeem. Use Aggregation to get SUM per line.'),
    'field' => array(
      'handler' => 'views_handler_field_numeric',
      'id' => 'numeric',
      'click sortable' => TRUE, 
    ),
    'filter' => array(
      'id' => 'numeric',
      'handler' => 'views_handler_filter_numeric',
    ),
    'sort' => array(
      'id' => 'standard',
      'handler' => 'views_handler_sort',
    ),
  );

  $data['uc_product_redeem']['note'] = array(
    'title' => t('Note (event)'),
    'help'  => t('Optional note recorded with a single redemption event.'),
    'field' => array(
      'handler' => 'views_handler_field',
    ),
  );

  $data['uc_product_redeem']['context'] = array(
    'title' => t('Context'),
    'help'  => t('Source/context string (e.g., inline, bulk, legacy-link).'),
    'field' => array(
      'handler' => 'views_handler_field',
    ),
  );

  $data['uc_product_redeem']['redeemed_by_name'] = array(
    'title' => t('Staff name'),
    'help'  => t('Display name recorded for the event.'),
    'field' => array(
      'handler' => 'views_handler_field',
    ),
  );

  $data['uc_product_redeem']['created'] = array(
    'title' => t('Created'),
    'help'  => t('Timestamp of the redemption event.'),
    'field' => array(
      'handler' => 'views_handler_field_date',
    ),
    'filter' => array(
      'handler' => 'views_handler_filter_date',
    ),
    'sort' => array(
      'handler' => 'views_handler_sort_date',
    ),
  );

  // When BASE TABLE = uc_product_redeem, offer explicit relationships OUT to
  // orders and order_products (optional, never auto-added).
  $data['uc_product_redeem']['order_rel'] = array(
    'title' => t('Order (by order_id)'),
    'help'  => t('Relate a redemption event to its order.'),
    'relationship' => array(
      'base'               => 'uc_orders',
      'base field'         => 'order_id',
      'relationship field' => 'order_id',
      'handler'            => 'views_handler_relationship',
      'label'              => t('Order'),
    ),
  );
  $data['uc_product_redeem']['op_rel'] = array(
    'title' => t('Order product (by order_id + line id)'),
    'help'  => t('Relate a redemption event to its order line item.'),
    'relationship' => array(
      'base'               => 'uc_order_products',
      'base field'         => 'order_product_id',
      'relationship field' => 'order_product_id',
      'handler'            => 'views_handler_relationship',
      'label'              => t('Order product'),
    ),
  );

  return $data;
}

/**
 * Implements hook_views_data_alter().
 *
 * Add pseudo-fields on uc_order_products:
 *  - ucpr_actions   (quick links)
 *  - ucpr_remaining (computed Remaining)
 */
function uc_product_redeem_views_data_alter(&$data) {
  if (!isset($data['uc_order_products'])) {
    return;
  }

  $handlers_path = drupal_get_path('module', 'uc_product_redeem') . '/includes';

  // Relationship: uc_order_products -> uc_product_redeem (events)
  // This removes ambiguity when adding "Redeem delta (qty)" to an order-products view.
  $data['uc_order_products']['ucpr_events'] = array(
    'title' => t('Redeem info'),
    'help'  => t('Relates an order product to its redeem record.'),
    'relationship' => array(
      'base'                => 'uc_product_redeem',
      'base field'          => 'order_product_id',
      'relationship field'  => 'order_product_id',
      'handler'             => 'views_handler_relationship',
      'label'               => t('Redeem events'),
      //'file'              => 'uc_product_redeem.views_handlers.inc',
      //'path'              => $handlers_path,
    ),
  );

  // Per-line Quick Redeem 1 / Quick Unredeem 1 actions.
  $data['uc_order_products']['ucpr_actions'] = array(
    'title' => t('Redeem/Unredeem 1'),
    'help'  => t('Render quick links to redeem/unredeem 1 unit for this line item.'),
    'field' => array(
      'handler' => 'uc_product_redeem_views_field_actions',
      'file'    => 'uc_product_redeem.views_handlers.inc',
      'path'    => $handlers_path,
    ),
  );

  // Per-line Redeem all / Unredeem all actions.
  $data['uc_order_products']['ucpr_actions_all'] = array(
    'title' => t('Redeem/Unredeem All'),
    'help'  => t('Per-line "Redeem all" / "Unredeem all" buttons.'),
    'field' => array(
      'handler' => 'uc_product_redeem_views_field_actions_all',
      'file'    => 'uc_product_redeem.views_handlers.inc',
      'path'    => $handlers_path,
    ),
  );

  // Per-line Redeem X / Unredeem X actions with qty input.
  $data['uc_order_products']['ucpr_actions_x'] = array(
    'title' => t('Redeem/Unredeem X'),
    'help'  => t('Per-line "Redeem X" / "Unredeem X" with a quantity input.'),
    'field' => array(
      'handler' => 'uc_product_redeem_views_field_actions_x',
      'file'    => 'uc_product_redeem.views_handlers.inc',
      'path'    => $handlers_path,
    ),
  );

  // Redeemed total (computed) pseudo-field.
  $data['uc_order_products']['ucpr_redeemed_total'] = array(
    'title' => t('Redeemed total'),
    'help'  => t('Sum of redemption deltas for this line (does not require View aggregation).'),
    'field' => array(
      'handler' => 'uc_product_redeem_views_field_redeemed_total',
      'file'    => 'uc_product_redeem.views_handlers.inc',
      'path'    => $handlers_path,
    ),
  );

  // Remaining computed field.
  $data['uc_order_products']['ucpr_remaining'] = array(
    'title' => t('Remaining'),
    'help'  => t('Ordered minus redeemed for this line item.'),
    'field' => array(
      'handler' => 'uc_product_redeem_views_field_remaining',
      'file'    => 'uc_product_redeem.views_handlers.inc',
      'path'    => $handlers_path,
    ),
  );

  // First redeemed time.
  $data['uc_order_products']['ucpr_first_redeemed'] = array(
    'title' => t('First redeemed (date)'),
    'help'  => t('First time the line was redeemed (no joins required).'),
    'field' => array(
      'handler' => 'uc_product_redeem_views_field_first_redeemed_ts',
      'file'    => 'uc_product_redeem.views_handlers.inc',
      'path'    => $handlers_path,
    ),
  );

  // Last redeemed time.
  $data['uc_order_products']['ucpr_last_redeemed'] = array(
    'title' => t('Last redeemed (date)'),
    'help'  => t('Most recent redeem time for the line (no joins required).'),
    'field' => array(
      'handler' => 'uc_product_redeem_views_field_last_redeemed_ts',
      'file'    => 'uc_product_redeem.views_handlers.inc',
      'path'    => $handlers_path,
    ),
  );

  // Last note.
  $data['uc_order_products']['ucpr_last_note'] = array(
    'title' => t('Last redemption note'),
    'help'  => t('Note from the most recent redemption on this line.'),
    'field' => array(
      'handler' => 'uc_product_redeem_views_field_last_note',
      'file'    => 'uc_product_redeem.views_handlers.inc',
      'path'    => $handlers_path,
    ),
  );

  // Last redeemed by.
  $data['uc_order_products']['ucpr_last_by'] = array(
    'title' => t('Last redeemed by'),
    'help'  => t('Staff name from the most recent redemption on this line.'),
    'field' => array(
      'handler' => 'uc_product_redeem_views_field_last_by',
      'file'    => 'uc_product_redeem.views_handlers.inc',
      'path'    => $handlers_path,
    ),
  );    
}
