<?php

/**
 * @file
 * Default Views for uc_product_redeem.
 */

/**
 * Implements hook_views_default_views().
 */
function uc_product_redeem_views_default_views() {
  $views = array();

  $view = new view();
  $view->name = 'ucpr_order_lines';
  $view->description = 'Order lines with redemption totals and quick actions.';
  $view->tag = 'uc_product_redeem';
  $view->base_table = 'uc_order_products';
  $view->human_name = 'Product Redeem: Order lines';
  $view->core = 7;
  $view->api_version = '3.0';
  $view->disabled = FALSE;

  // Defaults.
  $handler = $view->new_display('default', 'Defaults', 'default');
  $handler->display->display_options['use_ajax'] = FALSE;
  $handler->display->display_options['pager']['type'] = 'none';
  $handler->display->display_options['access']['type'] = 'perm';
  $handler->display->display_options['access']['perm'] = 'access content';
  $handler->display->display_options['style_plugin'] = 'table';
  $handler->display->display_options['row_plugin'] = 'fields';
  // NOTE: no group_by. We keep one row per order-product naturally.

  /* No results behavior: Global: Unfiltered text */
  $handler->display->display_options['empty']['area_text_custom']['id'] = 'area_text_custom';
  $handler->display->display_options['empty']['area_text_custom']['table'] = 'views';
  $handler->display->display_options['empty']['area_text_custom']['field'] = 'area_text_custom';
  $handler->display->display_options['empty']['area_text_custom']['empty'] = TRUE;
  $handler->display->display_options['empty']['area_text_custom']['content'] = 'No Products available for redemption.';
  $handler->display->display_options['defaults']['relationships'] = FALSE;

  /* Relationship: Ordered product: Node */
  $handler->display->display_options['relationships']['nid']['id'] = 'nid';
  $handler->display->display_options['relationships']['nid']['table'] = 'uc_order_products';
  $handler->display->display_options['relationships']['nid']['field'] = 'nid';
  $handler->display->display_options['defaults']['fields'] = FALSE;
    
  // Sort by title ASC.
  $handler->display->display_options['sorts']['title'] = array(
    'id' => 'title',
    'table' => 'uc_order_products',
    'field' => 'title',
    'order' => 'ASC',
  );

  // Contextual filter: Order ID from URL.
  $handler->display->display_options['arguments']['order_id'] = array(
    'id' => 'order_id',
    'table' => 'uc_order_products',
    'field' => 'order_id',
    'default_action' => 'empty',
    'default_argument_type' => 'none',
    'specify_validation' => TRUE,
    'validate' => array('type' => 'numeric'),
  );

  // FIELDS — include IDs.
  // Order ID.
  $handler->display->display_options['fields']['order_id'] = array(
    'id' => 'order_id',
    'table' => 'uc_order_products',
    'field' => 'order_id',
    'label' => t('Order ID'),
  );

  // Line item ID.
  $handler->display->display_options['fields']['order_product_id'] = array(
    'id' => 'order_product_id',
    'table' => 'uc_order_products',
    'field' => 'order_product_id',
    'label' => t('Line item ID'),
  );

  // Item title.
  $handler->display->display_options['fields']['title'] = array(
    'id' => 'title',
    'table' => 'uc_order_products',
    'field' => 'title',
    'label' => t('Item'),
  );

  // Ordered qty.
  $handler->display->display_options['fields']['qty'] = array(
    'id' => 'qty',
    'table' => 'uc_order_products',
    'field' => 'qty',
    'label' => t('Qty'),
    'element_label_colon' => FALSE,
  );

  // Redeemed total (computed).
  $handler->display->display_options['fields']['ucpr_redeemed_total'] = array(
    'id' => 'ucpr_redeemed_total',
    'table' => 'uc_order_products',
    'field' => 'ucpr_redeemed_total',
    'label' => t('Redeemed'),
    'element_label_colon' => FALSE,
  );

  // Remaining (computed).
  $handler->display->display_options['fields']['ucpr_remaining'] = array(
    'id' => 'ucpr_remaining',
    'table' => 'uc_order_products',
    'field' => 'ucpr_remaining',
    'label' => t('Remaining'),
    'element_label_colon' => FALSE,
  );

  // Quick actions.
  $handler->display->display_options['fields']['ucpr_actions'] = array(
    'id' => 'ucpr_actions',
    'table' => 'uc_order_products',
    'field' => 'ucpr_actions',
    'label' => t('Action'),
    'element_label_colon' => FALSE,
  );

  // Embed display (used by the redeem page when you enable it in settings).
  $handler = $view->new_display('embed', 'Embed: Order lines', 'embed');

  $views[$view->name] = $view;

// === Events view (base table: uc_product_redeem) ===
  $v2 = new view();
  $v2->name = 'ucpr_redeem_events';
  $v2->description = 'Redemption events log with order & product context.';
  $v2->tag = 'uc_product_redeem';
  $v2->base_table = 'uc_product_redeem';
  $v2->human_name = 'Product Redeem: Events log';
  $v2->core = 7;
  $v2->api_version = '3.0';
  $v2->disabled = FALSE;

  $d = $v2->new_display('default', 'Defaults', 'default');
  $d->display->display_options['use_ajax'] = FALSE;
  $d->display->display_options['pager']['type'] = 'full';
  $d->display->display_options['pager']['options']['items_per_page'] = 50;
  $d->display->display_options['access']['type'] = 'perm';
  $d->display->display_options['access']['perm'] = 'access content';
  $d->display->display_options['style_plugin'] = 'table';
  $d->display->display_options['row_plugin'] = 'fields';

  // Relationships to orders and order products.
  $d->display->display_options['relationships']['order_rel'] = array(
    'id' => 'order_rel',
    'table' => 'uc_product_redeem',
    'field' => 'order_rel',
    'label' => t('Order'),
    'required' => FALSE,
  );
  $d->display->display_options['relationships']['op_rel'] = array(
    'id' => 'op_rel',
    'table' => 'uc_product_redeem',
    'field' => 'op_rel',
    'label' => t('Order product'),
    'required' => FALSE,
  );

  // Filters (exposed).
  $d->display->display_options['filters']['created'] = array(
    'id' => 'created',
    'table' => 'uc_product_redeem',
    'field' => 'created',
    'operator' => '>=',
    'exposed' => TRUE,
    'expose' => array(
      'operator_id' => 'created_op', 
      'operator' => 'created_op', 
      'label' => t('From date'),
      'identifier' => 'created', 
    ),
  );
  $d->display->display_options['filters']['qty_sign'] = array(
    'id' => 'qty',
    'table' => 'uc_product_redeem',
    'field' => 'qty',
    'operator' => '!=',
    'value' => array(
      'min' => '0',
      'max' => '0',
      'value' => '0',
    ),
    'exposed' => TRUE,
    'expose' => array(
      'label' => t('Qty (non-zero to show events)'),
      'identifier' => 'qty',
    ),
  );

  // Fields.
  $d->display->display_options['fields']['created'] = array(
    'id' => 'created',
    'table' => 'uc_product_redeem',
    'field' => 'created',
    'label' => t('Date'),
  );
  $d->display->display_options['fields']['order_id'] = array(
    'id' => 'order_id',
    'table' => 'uc_product_redeem',
    'field' => 'order_id',
    'label' => t('Order ID'),
  );
  $d->display->display_options['fields']['order_product_id'] = array(
    'id' => 'order_product_id',
    'table' => 'uc_product_redeem',
    'field' => 'order_product_id',
    'label' => t('Line item ID'),
  );
  $d->display->display_options['fields']['title'] = array(
    'id' => 'title',
    'table' => 'uc_order_products',
    'field' => 'title',
    'relationship' => 'op_rel',
    'label' => t('Item'),
  );
  $d->display->display_options['fields']['qty'] = array(
    'id' => 'qty',
    'table' => 'uc_product_redeem',
    'field' => 'qty',
    'label' => t('Delta'),
  );
  $d->display->display_options['fields']['redeemed_by_name'] = array(
    'id' => 'redeemed_by_name',
    'table' => 'uc_product_redeem',
    'field' => 'redeemed_by_name',
    'label' => t('Staff'),
  );
  $d->display->display_options['fields']['context'] = array(
    'id' => 'context',
    'table' => 'uc_product_redeem',
    'field' => 'context',
    'label' => t('Context'),
  );
  $d->display->display_options['fields']['note'] = array(
    'id' => 'note',
    'table' => 'uc_product_redeem',
    'field' => 'note',
    'label' => t('Note'),
  );

  // Expose an embed display for blocks/pages.
  $v2->new_display('embed', 'Embed: Events log', 'embed');

  $views['ucpr_redeem_events'] = $v2;

  return $views;
}
