# UI Patterns Disable

Module that allows controlling the activation of UI Patterns (SDC) components via `.info.yml` files in themes and modules.

## Description

This module allows fine-grained management of which SDC components are available by analyzing `.info.yml` files from themes and modules. It provides two control mechanisms:

1. **`components`** : Whitelist of components guaranteed to be active (absolute priority, additive)
2. **`components-disabled`** : List of components to disable globally (across all themes/modules)

## Installation
Enable the module via Drupal's administration interface (`/admin/modules`) or via Drush:

```bash
drush en ui_patterns_disable -y
```

## Configuration

### Format in `.info.yml` files

Add the following keys to your custom theme's `.info.yml` file.

#### `components` key

Whitelist of SDC components that must be **guaranteed active**. This key has **absolute priority** over `components-disabled` and can reference components from any theme or module.

**Behavior:**
- Listed components are **always active**, even if they are disabled via `components-disabled`
- This key is **additive**: it guarantees the activation of specific components but does not disable others
- Other components remain available by default, unless explicitly disabled

```yaml
components:
  - theme_name/component_name_1
  - module_name/component_name_2
  - other_theme/other_component
```

**Example:**

```yaml
name: 'My custom theme'
type: theme
base theme: my_base_theme

components:
  - my_current_theme/mh_navbar
  - any_module/button_system
  - my_base_theme/button
```

In this example:
- `mh_navbar`, `button_system`, and `button` are **guaranteed active**
- All other components remain available by default
- These components will remain active even if disabled via `components-disabled`

#### `components-disabled` key

List of SDC components to **disable globally**, regardless of which theme or module provides them.

**Supported formats:**
- Individual components: `extension_name/component_name`
- Wildcard to disable all components of an extension: `extension_name/*`
- Support for themes and modules

```yaml
components-disabled:
  - extension_name/component_name
  - other_extension/other_component
  - extension_name/*  # Disables all components of this extension
```

**Example:**

```yaml
name: 'My custom theme'
type: theme
base theme: my_base_theme

components-disabled:
  - my_base_theme/navbar
  - any_module/*
  - flowbite/*
```

In this example:
- The `navbar` component from `my_base_theme` theme will be disabled
- **All** components from the `any_module` module will be disabled
- **All** components from the `flowbite` module will be disabled

### Component ID format

Components are identified by their ID in the format:
```
extension_name/component_name
```

Where `extension_name` can be a theme or a module.

**Examples:**
- `my_current_theme/mh_navbar` (theme)
- `my_base_theme/navbar` (theme)
- `any_module/button_system` (module)
- `any_module/*` (wildcard to disable all components of the module)

## Usage examples

### Example 1: Guarantee certain components are active (additive whitelist)

In `my_current_theme.info.yml`:

```yaml
name: ' my_current_theme'
type: theme
base theme: my_base_theme

components:
  - my_current_theme/mh_navbar
  - any_module/button_system
  - my_base_theme/button
```

Result:
- `mh_navbar`, `button_system`, and `button` are **guaranteed active** (absolute priority)
- All other components remain available by default

### Example 2: Disable specific components

In `my_current_theme.info.yml`:

```yaml
name: 'my_current_theme'
type: theme
base theme: my_base_theme

components-disabled:
  - my_base_theme/navbar
  - my_base_theme/footer
```

Result:
- The `navbar` and `footer` components from `my_base_theme` will be disabled
- All other components remain active

### Example 3: Disable all components of an extension (wildcard)

In `my_current_theme.info.yml`:

```yaml
name: 'my_current_theme'
type: theme
base theme: my_base_theme

components-disabled:
  - any_module/*
  - flowbite/*
```

Result:
- **All** components from the `any_module` module are disabled
- **All** components from the `flowbite` module are disabled
- Components from other extensions remain active

### Example 4: Combination - Whitelist with priority over wildcard

In `my_current_theme.info.yml`:

```yaml
name: 'my_current_theme'
type: theme
base theme: my_base_theme

components:
  - any_module/button_system
  - my_base_theme/button
  - my_base_theme/card

components-disabled:
  - any_module/*
  - my_base_theme/*
```

Result:
- `button_system`, `button`, and `card` are **guaranteed active** (even with wildcards)
- All **other** components from `any_module` are disabled
- All **other** components from `my_base_theme` are disabled
- Components from other extensions remain active

## Behavior

### Processing order and priorities

The module reads `.info.yml` files from **all installed themes and modules** (no need for them to be enabled).

**Priority order during filtering:**

1. **PRIORITY 1**: If the component is in the `components` list (whitelist) → **kept** (absolute priority, even if disabled elsewhere)
2. **PRIORITY 2**: If the entire extension is disabled via `extension/*` → **removed**
3. **PRIORITY 3**: If the component is explicitly disabled in `components-disabled` → **removed**
4. **PRIORITY 4**: By default, the component is **kept** (the whitelist is additive, not restrictive)

**Important:**
- The `components` key can reference components from any theme or module
- The `components` key has **absolute priority**: a whitelisted component remains active even if disabled via `components-disabled`
- The `components` key is **additive**: it guarantees the activation of certain components, but others remain available by default
- `.info.yml` files are read from all themes and modules, even if they are not enabled
- **Backward compatibility**: The old `components-override` key is still supported but deprecated. Use `components-disabled` for new configurations

## Troubleshooting

### The module doesn't seem to work

1. Verify that the module is enabled:
   ```bash
   drush pm:list --status=enabled | grep ui_patterns_disable
   ```

2. Clear Drupal cache:
   ```bash
   drush cache:rebuild
   ```

3. Check Drupal logs for any errors when reading `.info.yml` files:
   ```bash
   drush watchdog:show --filter=ui_patterns_disable
   ```

### Components are not disabled

- Verify that component IDs use the format `theme_name/component_name`
- Make sure theme and component names are correct
- Clear cache after modifying a `.info.yml` file
