<?php

declare(strict_types=1);

namespace Drupal\ui_patterns_ui_fieldgroups\Element;

use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Security\TrustedCallbackInterface;
use Drupal\Core\Theme\ComponentPluginManager;

/**
 * Our additions to the SDC render element.
 */
class DisplayFormFieldGroup implements TrustedCallbackInterface {

  /**
   * Constructs a ComponentElementAlter.
   */
  public function __construct(protected ComponentPluginManager $componentPluginManager) {}

  /**
   * {@inheritdoc}
   */
  public static function trustedCallbacks() {
    return ['process'];

  }

  /**
   * Alter SDC component element.
   *
   * The ::normalizeProps() methods logic has been moved to
   * TwigExtension::normalizeProps() in order to be executed also when
   * components are loaded from Twig include or embed.
   */
  public static function process(array $element, FormStateInterface $form_state): array {
    /** @var \Drupal\ui_patterns_ui\Entity\ComponentFormDisplay $display */
    $display = $element['#display'] ?? NULL;
    if ($display === NULL) {
      return $element;
    }

    $display_options = $display->getPropSlotOptions();
    $groups = ui_patterns_ui_fieldgroups_info($display);
    foreach ($display_options as $display_option_id => $option) {
      if (isset($groups[$display_option_id])) {
        $element[$display_option_id] = [];
        $group = $groups[$display_option_id];
        $complete_form = $form_state->getCompleteForm();
        field_group_field_group_form_process($element[$display_option_id], $group, $complete_form);
      }
      if (!empty($option['parent'])) {
        $parents = $element['#parents'];
        $parents[] = $option['parent'];
        if (str_starts_with($display_option_id, 'group_')) {
          $element[$display_option_id]['#group'] = $option['parent'];
        }
        else {
          $element[$display_option_id]['#group'] = implode('][', $parents);
        }
      }
    }

    return $element;
  }

}
